package com.cybelia.sandra.services.ejb3;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.entities.ActionSecurite;
import com.cybelia.sandra.entities.ActionSecuriteDAO;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.ChauffeurDAO;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.EleveurDAO;
import com.cybelia.sandra.entities.Etape;
import com.cybelia.sandra.entities.EtapeDAO;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.InfoAccessDAO;
import com.cybelia.sandra.entities.Lieu;
import com.cybelia.sandra.entities.LieuDAO;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.LigneProduitDAO;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteDAO;
import com.cybelia.sandra.entities.StatutEnum;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourDAO;
import com.cybelia.sandra.entities.TourTypeModif;
import com.cybelia.sandra.entities.TypeConnectionEnum;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.UserIndicateursDAO;
import com.cybelia.sandra.entities.Usine;
import com.cybelia.sandra.entities.UsineDAO;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.sig.PointGPSDAO;
import com.cybelia.sandra.entities.sig.TraceGPS;
import com.cybelia.sandra.entities.sig.TraceGPSDAO;
import com.cybelia.sandra.entities.synchro.Log;
import com.cybelia.sandra.entities.synchro.LogDAO;
import com.cybelia.sandra.entities.trace.CREtape;
import com.cybelia.sandra.entities.trace.CREtapeDAO;
import com.cybelia.sandra.entities.trace.CRTour;
import com.cybelia.sandra.entities.trace.CRTourDAO;
import com.cybelia.sandra.entities.trace.CRUsine;
import com.cybelia.sandra.entities.trace.CRUsineDAO;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviEtapeDAO;
import com.cybelia.sandra.entities.trace.SuiviLigneProduit;
import com.cybelia.sandra.entities.trace.SuiviLigneProduitDAO;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviTourDAO;
import com.cybelia.sandra.entities.trace.SuiviUsine;
import com.cybelia.sandra.entities.trace.SuiviUsineDAO;
import com.cybelia.sandra.services.ServiceHelper;
import com.cybelia.sandra.services.ServiceSuivi;
import com.cybelia.sandra.services.local.ServiceCommonLocal;
import com.cybelia.sandra.services.local.ServiceNotifierLocal;
import com.cybelia.sandra.services.local.ServiceSuiviLocal;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.util.DateUtil;

import javax.annotation.security.PermitAll;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@Stateless
@SecurityDomain("sandra")
@PermitAll
public class ServiceSuiviImpl extends BaseServiceImpl implements ServiceSuivi, ServiceSuiviLocal {

    private static final org.apache.commons.logging.Log log = LogFactory.getLog(ServiceSuiviImpl.class);

    @EJB
    ServiceNotifierLocal serviceNotifier;

    @EJB
    ServiceCommonLocal serviceCommon;

    public void setServiceNotifier(ServiceNotifierLocal serviceNotifier) {
        this.serviceNotifier = serviceNotifier;
    }

    public void setServiceCommon(ServiceCommonLocal serviceCommon) {
        this.serviceCommon = serviceCommon;
    }

    @Override
    @Transaction
    public void updateEleveur(Eleveur eleveur) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void updateEleveur(TopiaContext transaction, Eleveur eleveur) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " updateEleveur " + eleveur.getNom());
        }
        // DAOs
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(transaction);
        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO(transaction);

        // Récupération de l'ancien
        String codeSociete = eleveur.getSociete().getCode();
        Societe societe = societeDAO.findByCode(codeSociete);
        Eleveur eleveurOld = eleveurDAO.findByNaturalId(societe, eleveur.getCode());

        if (eleveurOld != null) {

            serviceCommon.notifyChangedBreeder(transaction, "updateBreeder", getUserLogin(), eleveurOld, eleveur);

            // Modification sans validation
            serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, Eleveur.PROPERTY_RAISON_SOCIALE);
            serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, Eleveur.PROPERTY_TELEPHONE);
            serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, Eleveur.PROPERTY_MOBILE);
            serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, Eleveur.PROPERTY_ADRESSE);
            serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, Eleveur.PROPERTY_VILLE);
            serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, Eleveur.PROPERTY_CODE_POSTAL);
            serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, Eleveur.PROPERTY_EMAIL);
            serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, Eleveur.PROPERTY_CODE_INSEE);
            serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, Eleveur.PROPERTY_CONTRAINTE_HORAIRE);
            serviceCommon.copyEntityIfNecessary(transaction, eleveur, eleveurOld, Eleveur.PROPERTY_COMMENTAIRE);

            eleveurOld.setNbTomTomGPSModif(eleveur.getNbTomTomGPSModif());

            eleveurDAO.update(eleveurOld);

        } else {
            String message = "Eleveur (" + eleveur.getCode() + ") not found. The user '" + getUserLogin() + "' probably does not have enough permissions.";
            if (log.isErrorEnabled()) {
                log.error(message);
            }
            throw new TopiaException(message);
        }
    }

    @Override
    @Transaction
    public void updateGPS(String topiaIdLieu, PointGPS pointGPS) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void updateGPS(TopiaContext transaction, String topiaIdLieu, PointGPS pointGPS) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " updateGPS lieu " + topiaIdLieu);
        }

        // DAOs
        PointGPSDAO pointGPSDAO = SandraDAOHelper.getPointGPSDAO(transaction);
        LieuDAO lieuDAO = SandraDAOHelper.getLieuDAO(transaction);

        Lieu lieu = lieuDAO.findByTopiaId(topiaIdLieu);
        if (lieu != null) {
            PointGPS pointGPSOld = lieu.getTomtomGPS();

            if (pointGPS.getPoint().getX() != 0 && pointGPS.getPoint().getY() != 0) {
                // gps point has really changed
                if (pointGPSOld == null || !(pointGPSOld.getPoint().getX() == pointGPS.getPoint().getX()
                        && pointGPSOld.getPoint().getY() == pointGPS.getPoint().getY())) {

                    // Suppression de l'ancien
                    if (pointGPSOld != null) {
                        pointGPSDAO.delete(pointGPSOld);
                        transaction.commitTransaction();
                    }

                    // Création
                    pointGPS.setTopiaId(TopiaId.create(PointGPS.class));
                    pointGPSDAO.update(pointGPS);

                    // Attachement
                    lieu.setTomtomGPS(pointGPS);

                    lieuDAO.update(lieu);

                    // If eleveur is concerned
                    Eleveur eleveur = SandraDAOHelper.getEleveurDAO(transaction).findByTopiaId(topiaIdLieu);
                    if (eleveur != null) {

                        // Get old gps points
                        double oldX = pointGPSOld == null || pointGPSOld.getPoint() == null ? 0 : pointGPSOld.getPoint().getX();
                        double oldY = pointGPSOld == null || pointGPSOld.getPoint() == null ? 0 : pointGPSOld.getPoint().getY();

                        // Get new GPS points
                        double newX = pointGPS.getPoint().getX();
                        double newY = pointGPS.getPoint().getY();

                        // gps point has really changed
                        if (oldX != newX || oldY != newY) {

                            // Envoie d'une notification
                            serviceNotifier.notifyEvent("updateBreederGPS",
                                    ServiceHelper.getSandraName(), ServiceHelper.getSandraUrl(),
                                    getUserLogin(), eleveur.getTopiaId(),
                                    String.valueOf(oldX),
                                    String.valueOf(oldY),
                                    String.valueOf(newX),
                                    String.valueOf(newY));

                            // Inc gps
                            serviceCommon.incNbGpsMaj(transaction);
                            serviceCommon.incNbMaj(transaction);
                        }
                    }
                }
            }
        }
    }

    @Override
    @Transaction
    public void updateInfoAcces(String topiaIdEleveur, InfoAccess accesEleveur, List<InfoAccess> accesSilos) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void updateInfoAcces(TopiaContext transaction, String topiaIdEleveur, InfoAccess accesEleveur, List<InfoAccess> accesSilos) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " updateInfoAcces topiaIdEleveur[" + topiaIdEleveur + "]");
        }

        // DAOs
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO(transaction);
        EleveurDAO eleveurDAO = SandraDAOHelper.getEleveurDAO(transaction);

        Eleveur eleveur = eleveurDAO.findByTopiaId(topiaIdEleveur);

        // Et si il n'est pas cree lors de la synchro
        if (accesEleveur == null) {

            // On le cree
            accesEleveur = infoAccessDAO.create();
            accesEleveur.setNiveauSecurite(eleveur.getNiveauSecurite());
            accesEleveur.setCommentaireSecurite(eleveur.getCommentaire());
            accesEleveur.setType(0);
        } else {
            String accesEleveurId = accesEleveur.getTopiaId();
            if (accesEleveurId == null) {
                // Création
                accesEleveur.setTopiaId(TopiaId.create(InfoAccess.class));
                eleveur.setAccesEleveur(accesEleveur);

            }
            // Mise à jour
            updateInfoAcces(transaction, true, eleveur, accesEleveur);
        }

        if (accesSilos != null) {
            for (InfoAccess accesSilo : accesSilos) {
                String accesSiloId = accesSilo.getTopiaId();
                if (accesSiloId == null) {
                    // Création
                    accesSilo.setTopiaId(TopiaId.create(InfoAccess.class));
                    eleveur.addAccesSilos(accesSilo);

                }
                // Mise à jour
                updateInfoAcces(transaction, false, eleveur, accesSilo);
            }
        }

        eleveurDAO.update(eleveur);
    }

    /*
     * Mise à jour d'un access info avec son point et sa trace GPS
     */
    protected void updateInfoAcces(TopiaContext transaction, boolean isAccesEleveur, Eleveur eleveur, InfoAccess infoAccessUpdate) throws TopiaException {

        // Recherche de l'ancien access
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO(transaction);
        String infoAccessId = infoAccessUpdate.getTopiaId();
        InfoAccess infoAccess = infoAccessDAO.findByTopiaId(infoAccessId);

        if (infoAccess == null) {
            log.warn("Info access not found with id[" + infoAccessId + "] name[" + infoAccessUpdate.getAccesSilo() + "]");
            log.warn("Ino access will not be updated");
            return;
        }

        String eleveurTopiaId = eleveur.getTopiaId();

        // create action security
        SandraHelper.createActionSecuriteIfNeeded(transaction, getUserLogin(), eleveur, infoAccessUpdate);

        if (isAccesEleveur) {
            serviceCommon.notifyChangedInfoAccess(transaction, "updateAccesEleveur", getUserLogin(), eleveurTopiaId, infoAccess, infoAccessUpdate);
        } else {
            serviceCommon.notifyChangedInfoAccess(transaction, "updateAccesSilo", getUserLogin(), eleveurTopiaId, infoAccess, infoAccessUpdate);
        }

        // Mise à jour des attributs
        serviceCommon.copyEntityIfNecessary(transaction, infoAccessUpdate, infoAccess, "accesSilo");
        serviceCommon.copyEntityIfNecessary(transaction, infoAccessUpdate, infoAccess, "commentaireSecurite");
        serviceCommon.copyEntityIfNecessary(transaction, infoAccessUpdate, infoAccess, "modeChargement");
        infoAccess.setEtat(infoAccessUpdate.getEtat());

        if (infoAccess.getNiveauSecurite() != infoAccessUpdate.getNiveauSecurite()) {
            infoAccess.setNiveauSecurite(infoAccessUpdate.getNiveauSecurite());
            if (!isAccesEleveur) {
                serviceCommon.incNbSecuMaj(transaction);
            }
            serviceCommon.incNbMaj(transaction);
        }

        // Must be never updated
//        infoAccess.setNomAcces(infoAccessUpdate.getNomAcces());

        Collection<String> risquesUpdated = infoAccessUpdate.getRisques();
        Collection<String> risques = infoAccess.getRisques();
        if (risques == null || !risques.equals(risquesUpdated)) {
            infoAccess.setRisques(risquesUpdated);
            serviceCommon.incNbMaj(transaction);
        }
        int newType = infoAccessUpdate.getType();
        int oldType = infoAccess.getType();
        if (newType != oldType) {
            infoAccess.setType(newType);
            serviceCommon.incNbMaj(transaction);
        }

        // Mise à jour des associations
        updateInfoAccessGPS(transaction, eleveur, infoAccess, infoAccessUpdate);
    }

    /*
     * Mise à jour des coordonnées GPS pour un infoAcess
     */
    protected void updateInfoAccessGPS(TopiaContext transaction, Eleveur eleveur, InfoAccess infoAccesOld, InfoAccess infoAccessUpdate) throws TopiaException {

        if (log.isDebugEnabled()) {
            log.debug("Update infoAccess GPS");
        }

        // DAOs
        InfoAccessDAO infoAccessDAO = SandraDAOHelper.getInfoAccessDAO(transaction);
        PointGPSDAO pointGPSDAO = SandraDAOHelper.getPointGPSDAO(transaction);
        TraceGPSDAO traceGPSDAO = SandraDAOHelper.getTraceGPSDAO(transaction);

        // Recuperation de l'ancien infoAccess
        PointGPS pointGPSOld = infoAccesOld.getGps();

        if (pointGPSOld != null) {
            pointGPSDAO.delete(pointGPSOld);
            transaction.commitTransaction();
        }

        // Création du point GPS
        PointGPS pointGPS = infoAccessUpdate.getGps();
        if (pointGPS != null) {
            pointGPS.setTopiaId(TopiaId.create(PointGPS.class));
            pointGPSDAO.update(pointGPS);
        }

        // Attachement
        infoAccesOld.setGps(pointGPS);

        // Création de la trace
        TraceGPS traceGPS = infoAccessUpdate.getTrace();
        if (traceGPS != null) {

            // Création des points trace
            List<PointGPS> pointsGPS = new ArrayList<PointGPS>(traceGPS.getListePoints());
            traceGPS.clearListePoints();
            for (PointGPS tracePoint : pointsGPS) {
                tracePoint.setTopiaId(TopiaId.create(PointGPS.class));
                pointGPSDAO.update(tracePoint);
                traceGPS.addListePoints(pointGPS);
            }
            traceGPS.setTopiaId(TopiaId.create(TraceGPS.class));
            traceGPSDAO.update(traceGPS);
            infoAccesOld.setTrace(traceGPS);
        }

        // Update
        infoAccessDAO.update(infoAccesOld);

        // Get old gps points
        double oldX = pointGPSOld == null || pointGPSOld.getPoint() == null ? 0 : pointGPSOld.getPoint().getX();
        double oldY = pointGPSOld == null || pointGPSOld.getPoint() == null ? 0 : pointGPSOld.getPoint().getY();

        // Get new GPS points
        double newX = pointGPS == null || pointGPS.getPoint() == null ? 0 : pointGPS.getPoint().getX();
        double newY = pointGPS == null || pointGPS.getPoint() == null ? 0 : pointGPS.getPoint().getY();

        // gps point has really changed
        if (oldX != newX || oldY != newY) {

            // If is an acces eleveur
            Eleveur eleveurFound = SandraDAOHelper.getEleveurDAO(transaction).findByAccesEleveur(infoAccesOld);
            if (eleveurFound != null) {
                // Envoie d'une notification
                serviceNotifier.notifyEvent("updateAccesEleveurGPS",
                        ServiceHelper.getSandraName(),
                        ServiceHelper.getSandraUrl(), getUserLogin(), eleveur.getTopiaId(),
                        String.valueOf(oldX),
                        String.valueOf(oldY),
                        String.valueOf(newX),
                        String.valueOf(newY));
            } else {
                // Envoie d'une notification
                serviceNotifier.notifyEvent("updateSiloGPS",
                        ServiceHelper.getSandraName(),
                        ServiceHelper.getSandraUrl(), getUserLogin(), eleveur.getTopiaId(), infoAccesOld.getTopiaId(),
                        String.valueOf(oldX),
                        String.valueOf(oldY),
                        String.valueOf(newX),
                        String.valueOf(newY));
            }
            serviceCommon.incNbMaj(transaction);
        }
    }

    @Override
    @Transaction
    public String updateSuiviTour(String topiaIdTourCurrent, SuiviTour suiviTour) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public String updateSuiviTour(TopiaContext transaction, String topiaIdTourCurrent, SuiviTour suiviTour) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " updateSuiviTour topiaIdTourCurrent[" + topiaIdTourCurrent + "]");
        }
//        if (serviceCommon.canUpdateEntity(transaction, topiaIdTourCurrent)) {

            log.info("Updating suivi tour for tour: " + topiaIdTourCurrent);
            if (log.isDebugEnabled()) {
                log.debug("Suivi tour: " + suiviTour);
            }

            // DAOs
            TourDAO tourDAO = SandraDAOHelper.getTourDAO(transaction);
            SuiviTourDAO suiviTourDAO = SandraDAOHelper.getSuiviTourDAO(transaction);

            // Récupération de l'ancien suivi
            Tour tour = tourDAO.findByTopiaId(topiaIdTourCurrent);
            if (log.isDebugEnabled()) {
                log.debug("Tour is: " + tour);
            }

            if (tour != null) {

                // Récupération et enregistrement du chauffeur
                if (suiviTour.getReel() != null) {
                    ChauffeurDAO chauffeurDAO = SandraDAOHelper.getChauffeurDAO(transaction);
                    Chauffeur chauffeur = chauffeurDAO.findByCode(suiviTour.getReel().getCode());
                    suiviTour.setReel(chauffeur);
                }

                // Création du suivi
                suiviTour.setTopiaId(TopiaId.create(SuiviTour.class));
                suiviTourDAO.update(suiviTour);

                // Attachement au tour
                tour.setSuiviTour(suiviTour);
                tourDAO.update(tour);

                SuiviTour suiviTourOld = tour.getSuiviTour();
                if (suiviTourOld != null && !suiviTourOld.getTopiaId().equals(suiviTour.getTopiaId())) {

                    // Vérification du changement de status
                    int oldStatus = suiviTourOld.getStatus();
                    int newStatus = suiviTour.getStatus();
                    if (oldStatus != newStatus) {
                        serviceCommon.incNbMaj(transaction);
                    }

                    // Récupération pour le nouveau suivi
                    suiviTour.setCRTour(suiviTourOld.getCRTour());
                    suiviTour.addAllSuiviEtapes(suiviTourOld.getSuiviEtapes());
                    suiviTour.addAllSuiviUsines(suiviTourOld.getSuiviUsines());

                    // Suppression de l'ancien suivi
                    suiviTourDAO.delete(suiviTourOld);
                    transaction.commitTransaction();
                } else {
                    // Chauffeur inconu
                    String chauffeur = suiviTour.getChauffeurNomPrenom();
                    if (StringUtils.isNotEmpty(chauffeur)) {
                        serviceNotifier.notifyEvent("updateReportDriverNotAffectedToTruck",
                                ServiceHelper.getSandraName(), getUserLogin(), chauffeur, tour.getTopiaId());
                    }
                }

                // Mise à jour de la durée du tour précédent
                Tour tourPrecedent = getPrecedentTour(transaction, tour);
                if (tourPrecedent != null) {

                    Tour tourPrecedentDuTourPrecedent = getPrecedentTour(transaction, tourPrecedent);
                    if (tourPrecedentDuTourPrecedent != null) {

                        SuiviUsine usineDepartTourPrecedent = getUsineDepartTour(tourPrecedent);
                        SuiviUsine usineDepartTourPrecedentDuTourPrecedent = getUsineDepartTour(tourPrecedentDuTourPrecedent);

                        if (usineDepartTourPrecedent != null && usineDepartTourPrecedentDuTourPrecedent != null) {
                            Date dateSortie = usineDepartTourPrecedent.getDateEntree();
                            Date dateEntree = usineDepartTourPrecedentDuTourPrecedent.getDateEntree();

                            if (dateEntree != null && dateSortie != null) {
                                Date date = new Date(dateSortie.getTime() - dateEntree.getTime());
                                SuiviTour suiviTourPrecedentDuTourPrecedent = tourPrecedentDuTourPrecedent.getSuiviTour();
                                suiviTourPrecedentDuTourPrecedent.setDuree(date);
                                suiviTourDAO.update(suiviTourPrecedentDuTourPrecedent);
                            }
                        }
                    }
                }

                // TMA 200 Transmettre les relevés de compteurs des véhicules à chaque chargement en usine
                try {
                    SandraHelper.addSuiviTourCSV(tour, suiviTour);
                } catch (IOException eee) {
                    log.error("Failled creating suivi tour CSV : ", eee);
                }
            } else {
                log.warn("No tour found with topiaId : " + topiaIdTourCurrent);
            }
//        } else {
//            String message = "You are not authorized to update Tour: " + topiaIdTourCurrent;
//            log.error(message);
//            throw new TopiaException(message);
//        }
        return suiviTour.getTopiaId();
    }

    /**
     * Calcul de l'usine de départ pour un tour
     *
     * @param tour tour
     * @return usine de départ
     */
    protected SuiviUsine getUsineDepartTour(Tour tour) {
        SuiviUsine depart = null;

        SuiviTour suiviTour = tour.getSuiviTour();
        if (suiviTour != null) {

            List<SuiviUsine> suiviUsines = suiviTour.getSuiviUsines();
            if (suiviUsines != null) {
                for (SuiviUsine usine : suiviUsines) {
                    if (depart == null || usine.getNouvelleOrdre() < depart.getNouvelleOrdre()) {
                        depart = usine;
                    }
                }
            }
        }

        return depart;
    }

    /**
     * Calcul du tour précédent au tour
     *
     * @param transaction transaction en cours
     * @param tour        tour
     * @return tour précédent
     * @throws TopiaException si erreur technique dans la base
     */
    protected Tour getPrecedentTour(TopiaContext transaction, Tour tour) throws TopiaException {
        Tour tourPrecedent = null;
        List tours = null;

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(tour.getDateLivraison());

        int numero = tour.getNumero();
        Camion camion = tour.getCamion();

        // Premier tour de la journée
        if (numero == 1) {
            String requete = "FROM com.cybelia.sandra.entities.Tour tour WHERE " +
                    "tour.dateLivraison >= :dateDebut " +
                    "AND tour.dateLivraison <= :dateFin " +
                    "AND tour.camion = :camion " +
                    "ORDER BY tour.numero DESC";

            // Remonte maximum sur 5 jours
            for (int i = 0; i < 5 && (tours == null || tours.isEmpty()); i++) {
                calendar.add(Calendar.DATE, -1);

                Date dateDebut = DateUtil.setMinTimeOfDay(calendar.getTime());
                Date dateFin = DateUtil.setMaxTimeOfDay(calendar.getTime());

                tours = transaction.findAll(requete,
                        "dateDebut", dateDebut,
                        "dateFin", dateFin,
                        "camion", camion);
            }

        } else {
            String requete = "FROM com.cybelia.sandra.entities.Tour tour WHERE " +
                    "tour.dateLivraison >= :dateDebut " +
                    "AND tour.dateLivraison <= :dateFin " +
                    "AND tour.camion = :camion " +
                    "AND tour.numero = :numero";

            Date dateDebut = DateUtil.setMinTimeOfDay(calendar.getTime());
            Date dateFin = DateUtil.setMaxTimeOfDay(calendar.getTime());

            tours = transaction.findAll(requete,
                    "dateDebut", dateDebut,
                    "dateFin", dateFin,
                    "camion", camion,
                    "numero", numero - 1);
        }

        if (tours != null && !tours.isEmpty()) {
            tourPrecedent = (Tour) tours.get(0);
        }

        return tourPrecedent;
    }

    @Override
    @Transaction
    public String updateSuiviEtape(String topiaIdTourCurrent, String topiaIdEtape, SuiviEtape suiviEtape) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public String updateSuiviEtape(TopiaContext transaction, String topiaIdTourCurrent, String topiaIdEtape, SuiviEtape suiviEtape) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " updateSuiviEtape topiaIdTourCurrent[" + topiaIdTourCurrent + "] topiaIdEtape[" + topiaIdEtape + "]");
        }
        // DAOs
        TourDAO tourDAO = SandraDAOHelper.getTourDAO(transaction);
        EtapeDAO etapeDAO = SandraDAOHelper.getEtapeDAO(transaction);
        SuiviEtapeDAO suiviEtapeDAO = SandraDAOHelper.getSuiviEtapeDAO(transaction);

        // Récupération de l'ancien suivi
        Etape etape = etapeDAO.findByTopiaId(topiaIdEtape);
        SuiviEtape suiviEtapeOld = suiviEtapeDAO.findByEtape(etape);

        // Attachement au suivi tour
        Tour tour = tourDAO.findByTopiaId(topiaIdTourCurrent);
        SuiviTour suiviTour = tour.getSuiviTour();

        if (suiviEtapeOld != null) {
            // Verification du changement dans l'ordre des étapes
            int oldNouvelleOrdre = suiviEtapeOld.getNouvelleOrdre();
            int newNouvelleOrdre = suiviEtape.getNouvelleOrdre();
            if (oldNouvelleOrdre != newNouvelleOrdre) {
                serviceCommon.incNbMaj(transaction);
            }

            // Récupération pour le nouveau suivi
            suiviEtape.setCREtape(suiviEtapeOld.getCREtape());

            // Suppression de l'ancien suivi
            //See SDRAMTNC-332
            if (!suiviTour.isSuiviEtapesEmpty()) {

                if (suiviTour.getSuiviEtapes().contains(suiviEtapeOld)) {
                    suiviTour.removeSuiviEtapes(suiviEtapeOld);
                }
            }
            suiviEtapeDAO.delete(suiviEtapeOld);
            transaction.commitTransaction();
        }

        // Création du suivi
        suiviEtape.setTopiaId(TopiaId.create(SuiviEtape.class));
        suiviEtape.setEtape(etape);
        suiviEtapeDAO.update(suiviEtape);

        if (suiviTour != null) {
            suiviTour.addSuiviEtapes(suiviEtape);
            SandraDAOHelper.getSuiviTourDAO(transaction).update(suiviTour);
        }
        return suiviEtape.getTopiaId();
    }

    @Override
    @Transaction
    public String updateSuiviUsine(String topiaIdTourCurrent, String codeUsine, int creationOrdreUsine, SuiviUsine suiviUsine) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public String updateSuiviUsine(TopiaContext transaction, String topiaIdTourCurrent, String codeUsine, int creationOrdreUsine, SuiviUsine suiviUsine) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " updateSuiviUsine topiaIdTourCurrent[" + topiaIdTourCurrent + "] codeUsine[" + codeUsine + "] creationOrdreUsine[" + creationOrdreUsine + "]");
        }
        // DAOs
        TourDAO tourDAO = SandraDAOHelper.getTourDAO(transaction);
        UsineDAO usineDAO = SandraDAOHelper.getUsineDAO(transaction);
        SuiviUsineDAO suiviUsineDAO = SandraDAOHelper.getSuiviUsineDAO(transaction);

        // Récupération de l'ancien suivi
        Tour tour = tourDAO.findByTopiaId(topiaIdTourCurrent);
        if (tour == null){
            log.info("No tour find with topiaId : " + topiaIdTourCurrent);
            return null;
        }
        Usine usine = usineDAO.findByCode(codeUsine);
        SuiviUsine suiviUsineOld = null;
        SuiviTour suiviTour = tour.getSuiviTour();
        if (suiviTour != null){
            List<SuiviUsine> suiviUsines = suiviTour.getSuiviUsines();
            if (suiviUsines != null && !suiviUsines.isEmpty()){
                for (Iterator<SuiviUsine> iterator = suiviUsines.iterator(); iterator.hasNext() && suiviUsineOld == null;) {
                    SuiviUsine item = iterator.next();
                    if (item.getCreationOrdre() == creationOrdreUsine
                            && item.getUsine().getCode().equals(codeUsine)) {
                        suiviUsineOld = item;
                    }
                }
            } else {
                log.error("SuiviUsines are null or empty for tour : " + topiaIdTourCurrent);
            }

            // Création du suivi
            if (suiviUsine == null){
                suiviUsine = suiviUsineDAO.create();
            } else {
                suiviUsine.setTopiaId(TopiaId.create(SuiviUsine.class));
            }
            suiviUsine.setUsine(usine);

            if (suiviUsineOld != null) {

                // Vérification du changement de l'heure de chargement
                Date oldHeureChargement = suiviUsineOld.getHeureChargement();
                Date newHeureChargement = suiviUsine.getHeureChargement();
                if (oldHeureChargement == null || !oldHeureChargement.equals(newHeureChargement)) {
                    serviceCommon.incNbMaj(transaction);
                }

                // Récupération pour le nouveau suivi
                suiviUsine.setCRUsine(suiviUsineOld.getCRUsine());
                suiviUsine.addAllSuiviLigneProduit(suiviUsineOld.getSuiviLigneProduit());

                // Suppression de l'ancien suivi
                //See SDRAMTNC-332
                if (!suiviTour.isSuiviUsinesEmpty()) {

                    if (suiviTour.getSuiviUsines().contains(suiviUsineOld)) {
                        suiviTour.removeSuiviUsines(suiviUsineOld);
                    }
                }
                suiviUsineDAO.delete(suiviUsineOld);
                transaction.commitTransaction();
            }
            // Save
            suiviUsineDAO.update(suiviUsine);

            // Attachement au suivi tour
            suiviTour.addSuiviUsines(suiviUsine);
            SandraDAOHelper.getSuiviTourDAO(transaction).update(suiviTour);
        } else {
            log.error("SuiviTour is null for tour " + topiaIdTourCurrent);
        }
        log.info("Adding suiviUsine : " + suiviUsine.getTopiaId());
        return suiviUsine.getTopiaId();
    }

    @Override
    @Transaction
    public void updateCRTour(String topiaIdSuiviTour, CRTour crTour, long updateSynchroNumber) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void updateCRTour(TopiaContext transaction, String topiaIdSuiviTour, CRTour crTour, long updateSynchroNumber)
                                                throws TopiaException {

        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " updateCRTour topiaIdSuiviTour[" + topiaIdSuiviTour + "]");
        }
        // DAOs
        SuiviTourDAO suiviTourDAO = SandraDAOHelper.getSuiviTourDAO(transaction);
        TourDAO tourDAO = SandraDAOHelper.getTourDAO(transaction);
        CRTourDAO crTourDAO = SandraDAOHelper.getCRTourDAO(transaction);
        LogDAO logDAO = SandraDAOHelper.getLogDAO(transaction);

        // Récupération de l'ancien compte rendu
        SuiviTour suiviTour = suiviTourDAO.findByTopiaId(topiaIdSuiviTour);

        // Recuperation du tour concerne
        Tour tour = tourDAO.findBySuiviTour(suiviTour);

        // Création du compte rendu
        crTour.setTopiaId(TopiaId.create(CRTour.class));
        crTourDAO.update(crTour);

        // Attachement au suivi tour
        suiviTour.setCRTour(crTour);
        suiviTourDAO.update(suiviTour);

        CRTour crTourOld = suiviTour.getCRTour();
        if (crTourOld != null) {
            // Suppression
            crTourDAO.delete(crTourOld);
            transaction.commitTransaction();
        }

        // Gestion des num de synchro
        // SL 19/03/2010, TMA 106 : Perte d'info lors des synchros sur les tours ?
        if (tour != null) {
            Log logEntity = logDAO.findByTourTopiaID(tour.getTopiaId());
            if (logEntity == null) {
                logEntity = logDAO.create("tourTopiaID", tour.getTopiaId());
            }
            logEntity.setSynchroNumber(updateSynchroNumber);
            logEntity.setTimeStamp(System.currentTimeMillis());
            logEntity.setTypeModif(TourTypeModif.MODIF);
            SandraDAOHelper.getLogDAO(transaction).update(logEntity);
        }
    }

    @Override
    @Transaction
    public void updateCREtape(String topiaIdSuiviEtape, CREtape crEtape) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void updateCREtape(TopiaContext transaction, String topiaIdSuiviEtape, CREtape crEtape) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " updateCREtape topiaIdSuiviEtape[" + topiaIdSuiviEtape + "]");
        }
        // DAOs
        SuiviEtapeDAO suiviEtapeDAO = SandraDAOHelper.getSuiviEtapeDAO(transaction);
        CREtapeDAO crEtapeDAO = SandraDAOHelper.getCREtapeDAO(transaction);

        // Récupération de l'ancien compte rendu
        SuiviEtape suiviEtape = suiviEtapeDAO.findByTopiaId(topiaIdSuiviEtape);

        // Création du compte rendu
        crEtape.setTopiaId(TopiaId.create(CREtape.class));
        crEtapeDAO.update(crEtape);

        // Suppression de l'ancienne étape
        // (doit être fait avant suiviEtape#setCREtape !!!)
        
        CREtape crEtapeOld = suiviEtape.getCREtape();
        if (crEtapeOld != null) {
            // Suppression
            crEtapeDAO.delete(crEtapeOld);
            transaction.commitTransaction();
        }
        
        // Attachement au suivi tour
        suiviEtape.setCREtape(crEtape);
        suiviEtapeDAO.update(suiviEtape);

        // Envoi de mail si pas RAS
        String livraisonStatut = crEtape.getLivraisonStatut();
        log.info("Livraison statut : " + livraisonStatut);
        if (!"RAS".equals(livraisonStatut)) {
            serviceNotifier.notifyEvent("updateReportKo",
                    ServiceHelper.getSandraName(),
                    getUserLogin(),
                    suiviEtape.getEtape().getTopiaId(),
                    SandraHelper.convertDateToString(new Date()),
                    serviceCommon.getLabel(transaction, "PGE", String.valueOf(crEtape.getPurge())),
                    crEtape.getLivraisonStatut(), crEtape.getCommentaireLivraison(),
                    SandraHelper.convertDateToString(crEtape.getEtapeHeureLivraison()));
        }
    }

    @Override
    @Transaction
    public void updateCRUsine(String topiaIdSuiviUsine, CRUsine crUsine) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void updateCRUsine(TopiaContext transaction, String topiaIdSuiviUsine, CRUsine crUsine) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " updateCRUsine topiaIdSuiviUsine[" + topiaIdSuiviUsine + "]");
        }
        // DAOs
        SuiviUsineDAO suiviUsineDAO = SandraDAOHelper.getSuiviUsineDAO(transaction);
        CRUsineDAO crUsineDAO = SandraDAOHelper.getCRUsineDAO(transaction);

        // Récupération de l'ancien compte rendu
        SuiviUsine suiviUsine = suiviUsineDAO.findByTopiaId(topiaIdSuiviUsine);

        // Création du compte rendu
        crUsine.setTopiaId(TopiaId.create(CRUsine.class));
        crUsineDAO.update(crUsine);

        // Attachement au suivi tour
        suiviUsine.setCRUsine(crUsine);
        suiviUsineDAO.update(suiviUsine);

        CRUsine crUsineOld = suiviUsine.getCRUsine();
        if (crUsineOld != null) {
            // Suppression
            crUsineDAO.delete(crUsine);
            transaction.commitTransaction();
        }
    }

    @Override
    @Transaction
    public void updateSuiviLigneProduit(String topiaIdLigneProduit, String topiaIdSuiviUsine, SuiviLigneProduit suiviLigneProduit) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public void updateSuiviLigneProduit(TopiaContext transaction, String topiaIdLigneProduit, String topiaIdSuiviUsine, SuiviLigneProduit suiviLigneProduit) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " updateSuiviLigneProduit topiaIdLigneProduit[" + topiaIdLigneProduit + "] topiaIdSuiviUsine[" + topiaIdSuiviUsine + "]");
        }
        //DAOs
        LigneProduitDAO ligneProduitDAO = SandraDAOHelper.getLigneProduitDAO(transaction);
        SuiviLigneProduitDAO suiviLigneProduitDAO = SandraDAOHelper.getSuiviLigneProduitDAO(transaction);
        SuiviUsineDAO suiviUsineDAO = SandraDAOHelper.getSuiviUsineDAO(transaction);

        // Récupération de l'ancien suivi ligne produit
        LigneProduit ligneProduit = ligneProduitDAO.findByTopiaId(topiaIdLigneProduit);
        SuiviUsine suiviUsine = suiviUsineDAO.findByTopiaId(topiaIdSuiviUsine);
        SuiviLigneProduit suiviLigneProduitOld = suiviLigneProduitDAO.findByLigneProduit(ligneProduit);
        if (suiviLigneProduitOld != null) {

            // Vérification du changement des compartiments
            String oldsCompartiments = suiviLigneProduitOld.getCompartiments();
            String newCompartiments = suiviLigneProduit.getCompartiments();
            if (oldsCompartiments == null || !oldsCompartiments.equals(newCompartiments)) {
                serviceCommon.incNbMaj(transaction);
            }

            // Suppression
            //See SDRAMTNC-332
            if (!suiviUsine.isSuiviLigneProduitEmpty()) {

                if (suiviUsine.getSuiviLigneProduit().contains(suiviLigneProduitOld)) {
                    suiviUsine.removeSuiviLigneProduit(suiviLigneProduitOld);
                }
            }
            suiviLigneProduitDAO.delete(suiviLigneProduitOld);
            transaction.commitTransaction();
        }

        // Création du suivi ligne produit
        suiviLigneProduit.setTopiaId(TopiaId.create(SuiviLigneProduit.class));
        suiviLigneProduit.setLigneProduit(ligneProduit);
        suiviLigneProduitDAO.update(suiviLigneProduit);

        // Attachement au suivi usine
        suiviUsine.addSuiviLigneProduit(suiviLigneProduit);
        suiviUsineDAO.update(suiviUsine);
        log.info("Adding suiviLigneProduit : " + suiviLigneProduit.getTopiaId());
    }

    @Override
    @Transaction
    public int getStatusForTour(String tourTopiaId) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public int getStatusForTour(TopiaContext transaction, String tourTopiaId) throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " updateSuiviLigneProduit tourTopiaId[" + tourTopiaId + "] getStatusForTour : " + tourTopiaId);
        }
        StatutEnum statut = null;

        //DAOs
        TourDAO tourDAO = SandraDAOHelper.getTourDAO(transaction);

        Tour tour = tourDAO.findByTopiaId(tourTopiaId);

        SuiviTour suiviTour = tour.getSuiviTour();
        List<LigneProduit> produits = new ArrayList<LigneProduit>();

        if (suiviTour != null) {
            //tour en livraison
            if (suiviTour.getStatus() == 4) {
                statut = StatutEnum.EN_COURS_LIVRAISON;
            }

            //tour termine
            if (suiviTour.getStatus() == -1) {
                statut = StatutEnum.TERMINE;
            }

            if (statut == null) {
                List<SuiviEtape> suiviEtapes = suiviTour.getSuiviEtapes();
                for (SuiviEtape suiviEtape : suiviEtapes) {
                    // En cas de mauvaise synchro, il se peut qu'il y a
                    // un suivi étape sans étape
                    Etape etape = suiviEtape.getEtape();
                    if (etape != null) {
                        produits.addAll(etape.getProduits());
                    }
                }
            }
        }
        List<Etape> etapes = tour.getEtapes();
        for (Etape etape : etapes) {
            produits.addAll(etape.getProduits());
        }
        statut = getStatutSteps(produits);
        int code = statut.getCode();
        if (log.isDebugEnabled()) {
            log.debug("Return code " + code + " for tour : " + tourTopiaId);
        }
        return code;
    }

    protected StatutEnum getStatutSteps(List<LigneProduit> produits) {
        StatutEnum statut;

        boolean oneAvailable = false; //un produit disponible
        boolean allAvailable = true; //tous les produits disponibles
        boolean oneCharged = false; //un produit charges

        for (LigneProduit produit : produits) {
            //calcul des statuts
            oneAvailable |= produit.getDisponible();
            allAvailable &= produit.getDisponible();
            oneCharged |= produit.getInfoChargement().getQuantite() > 0;
        }
        if (oneCharged) {
            statut = StatutEnum.CHARGE;
        } else if (allAvailable) {
            statut = StatutEnum.DISPONIBLE;
        } else if (oneAvailable) {
            statut = StatutEnum.SEMI_DISPONIBLE;
        } else {
            statut = StatutEnum.PLANIFIE;
        }

        return statut;
    }

    @Override
    @Transaction
    public UserIndicateurs updateSynchroStat(int typeConnection, boolean gprs, int sendSize, int recieveSize, int synchroNumber, int okSynchroNumber) throws TopiaException {
        throw new RuntimeException("This method must be never call");
    }

    public UserIndicateurs updateSynchroStat(TopiaContext transaction, int typeConnection, boolean gprs, int sendSize, int recieveSize, int synchroNumber, int okSynchroNumber) throws TopiaException {

        // Get type of connection
        TypeConnectionEnum typeConnectionEnum = TypeConnectionEnum.getTypeConnectionEnum(typeConnection);

        if (log.isDebugEnabled()) {
            log.debug("[" + getUserLogin() + "]" + " updateSynchroStat with connection of type " +
                    (gprs ? "SYNCHRO on GPRS" : typeConnectionEnum) +
                    " : sendSize[" + sendSize + "]" +
                    " recieveSize[" + recieveSize + "]" +
                    " synchroNumber[" + synchroNumber + "]" +
                    " okSynchroNumber[" + okSynchroNumber + "]");
        }

        // Inc synchro
        UserIndicateurs userIndicateurs = serviceCommon.incSynch(transaction, typeConnectionEnum, gprs, false);

        if (gprs) {
            // Inc send size
            userIndicateurs = serviceCommon.incNbOctetsSendGPRS(userIndicateurs, sendSize);

            // Inc recieveSize
            userIndicateurs = serviceCommon.incNbOctetsReceivedGPRS(userIndicateurs, recieveSize);
        } else {
            // Inc send size
            userIndicateurs = serviceCommon.incNbOctetsSendWifi(userIndicateurs, sendSize);

            // Inc recieveSize
            userIndicateurs = serviceCommon.incNbOctetsReceivedWifi(userIndicateurs, recieveSize);
        }

        // Inc synch in ko
        // Less current
        int synchKo = synchroNumber - okSynchroNumber;
        if (synchKo > 0) {
            userIndicateurs = serviceCommon.incNbSynchKo(userIndicateurs, synchKo - 1);
        }

        // Update
        UserIndicateursDAO userIndicateursDAO = SandraDAOHelper.getUserIndicateursDAO(transaction);
        userIndicateurs = userIndicateursDAO.update(userIndicateurs);

        return userIndicateurs;
    }
} //ServiceSuiviImpl
