package com.cybelia.sandra.services.ejb3;

import com.cybelia.sandra.SchedulerJobFactory;
import com.cybelia.sandra.ibu.IBU;
import com.cybelia.sandra.services.ServiceSchedule;
import com.cybelia.sandra.services.local.ServiceScheduleLocal;
import java.io.IOException;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaNotFoundException;

@Stateless
@SecurityDomain("sandra")
@PermitAll
public class ServiceScheduleImpl extends BaseServiceImpl implements ServiceSchedule, ServiceScheduleLocal {

    private static final Log log = LogFactory.getLog(ServiceScheduleImpl.class);

    @Override
    public void sendAllEleveurWhithNoGPS(TopiaContext transaction) throws Exception {
        new SchedulerJobFactory.NoCoordGPSVerfier().doAction(transaction);
    }

    @Override
    public void sendAllEleveurWhithGPSButNotLocked(TopiaContext transaction) throws Exception {
        new SchedulerJobFactory.NotLockedGPSVerifier().doAction(transaction);
    }

    @Override
    public void sendFindUnconnectedCamion(TopiaContext transaction) throws Exception {
        new SchedulerJobFactory.FindUnconnectedCamion().doAction(transaction);
    }

    @Override
    public void sendFindDangerousBreeder(TopiaContext transaction) throws Exception {
        new SchedulerJobFactory.FindDangerousBreeder().doAction(transaction);
    }

    @Override
    public void clearQueue(TopiaContext transaction) throws Exception {
        new SchedulerJobFactory.CleanUpNotification().doAction(transaction);
    }

    @Override
    @Transaction
    public void razNumberOfConnection(TopiaContext transaction) throws Exception {
        new SchedulerJobFactory.RazNumberOfConnection().doAction(transaction);
    }

    /*
     * Send stats notification
     */
    @Override
    @Transaction
    public void sendStatNotification(TopiaContext transaction) throws Exception {
        new SchedulerJobFactory.SendStatsNotification().doAction(transaction);
    }

    @Override
    public void injectIBU(String content) throws TopiaNotFoundException, IOException {
        IBU ibu = new IBU();
        ibu.injectIBUContent(content);
    }

    @Override
    public void injectLabels(String content) throws TopiaNotFoundException, IOException {
        IBU ibu = new IBU();
        ibu.injectLabels(content);
    }

    @Override
    public void injectUsines(String content) throws TopiaNotFoundException, IOException {
        IBU ibu = new IBU();
        ibu.injectUsines(content);
    }

    @Override
    public void injectCamions(String content) throws TopiaNotFoundException, IOException {
        IBU ibu = new IBU();
        ibu.injectCamions(content);
    }

    @Override
    public void injectChauffeurs(String content) throws TopiaNotFoundException, IOException {
        IBU ibu = new IBU();
        ibu.injectChauffeurs(content);
    }

    @Override
    public void injectTransporteurs(String content) throws TopiaNotFoundException, IOException {
        IBU ibu = new IBU();
        ibu.injectTransporteurs(content);
    }

    @Override
    public void injectAutorisations(String content) throws TopiaNotFoundException, IOException {
        IBU ibu = new IBU();
        ibu.injectAutorisations(content);
    }

    @Override
    public void injectUsers(String content) throws TopiaNotFoundException, IOException {
        IBU ibu = new IBU();
        ibu.injectUsers(content);
    }

    @Override
    public void injectEvents(String content) throws TopiaNotFoundException, IOException {
        IBU ibu = new IBU();
        ibu.injectEvents(content);
    }

    @Override
    public void injectEleveurGPS(String content) throws TopiaNotFoundException, IOException {
        IBU ibu = new IBU();
        ibu.injectEleveurGPS(content);
    }

    @Override
    public void injectEleveurDuplicated(String content) throws TopiaNotFoundException, IOException {
        IBU ibu = new IBU();
        ibu.injectEleveurDuplicated(content);
    }
}
