package com.cybelia.sandra.services.ejb3;

import com.cybelia.sandra.ibu.IBU;
import com.cybelia.sandra.services.InjectorIBU;
import com.cybelia.sandra.services.local.InjectorIBULocal;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.ejb3.annotation.SecurityDomain;

/**
 * @author letellier
 */
@Stateless
@SecurityDomain(value = "sandra")
@PermitAll
public class InjectorIBUImpl extends BaseServiceImpl implements InjectorIBU, InjectorIBULocal {

    protected static final Log log = LogFactory.getLog(InjectorIBUImpl.class);

    @Override
    public void injectIBU(String content) throws Exception {
        IBU ibu = new IBU();
        ibu.injectIBUContent(content);
    }

    @Override
    public void injectLabels(String content) throws Exception {
        IBU ibu = new IBU();
        ibu.injectLabels(content);
    }

    @Override
    public void injectUsines(String content) throws Exception {
        IBU ibu = new IBU();
        ibu.injectUsines(content);
    }

    @Override
    public void injectCamions(String content) throws Exception {
        IBU ibu = new IBU();
        ibu.injectCamions(content);
    }

    @Override
    public void injectChauffeurs(String content) throws Exception {
        IBU ibu = new IBU();
        ibu.injectChauffeurs(content);
    }

    @Override
    public void injectTransporteurs(String content) throws Exception {
        IBU ibu = new IBU();
        ibu.injectTransporteurs(content);
    }

    @Override
    public void injectAutorisations(String content) throws Exception {
        IBU ibu = new IBU();
        ibu.injectAutorisations(content);
    }

    @Override
    public void injectUsers(String content) throws Exception {
        IBU ibu = new IBU();
        ibu.injectUsers(content);
    }

    @Override
    public void injectEvents(String content) throws Exception {
        IBU ibu = new IBU();
        ibu.injectEvents(content);
    }

    @Override
    public void injectEleveurGPS(String content) throws Exception {
        IBU ibu = new IBU();
        ibu.injectEleveurGPS(content);
    }
}
