package com.cybelia.sandra.services.ejb3;

import com.cybelia.sandra.security.SecurityHelper;
import javax.interceptor.Interceptors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.taas.entities.TaasUser;

@Interceptors({TransactionManager.class})
public class BaseServiceImpl {

    private static final Log log = LogFactory.getLog(BaseServiceImpl.class);

    protected String getUserLogin() throws TopiaException {
        String login = "not found";

        try {
            TaasUser user = SecurityHelper.getUser();
            if (user != null) {
                login = user.getLogin();
            }
        } catch (Throwable eee) {
            log.error("Failed to get login", eee);
        } finally {
            return login;
        }
    }

} //BaseServiceImpl
