package com.cybelia.sandra.services;

import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Chauffeur;
import com.cybelia.sandra.entities.LigneProduit;
import com.cybelia.sandra.entities.Label;
import com.cybelia.sandra.entities.Tour;
import com.cybelia.sandra.entities.TourTypeModif;
import java.util.List;
import javax.ejb.Remote;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.nuiton.topia.TopiaException;

/**
 * Services pour la gestion des tours, c'est a dire la descente des donnees de
 * la base de donnees Sandra vers les PDA.
 *
 * @author julien
 */
@Remote
@RemoteBinding(jndiBinding="ServiceTourImpl/remote")
public interface ServiceTour {

    /**
     * Recupere les camions associes a partir d'un camion associe et principal
     */
    public List<Camion> getAssociatedCamionForPrincipalCamion(String codeSociete, String codeCamion) throws TopiaException;

    /**
     * Recupere le camion principal a partir d'un camion associe et principal
     */
    public Camion getPrincipalCamionWithCamionId(String codeSociete, String codeCamion) throws TopiaException;

    /**
     * Recupere la liste des chauffeurs par defaut pour un camions principal et associe
     */
    public List<Chauffeur> getChauffeursForCamion(String codeSociete, String codeCamion) throws TopiaException;

    /**
     * Recupere le chauffeur a partir du code
     *
     * @deprecated Code societe is not used any more
     */
    @Deprecated
    public Chauffeur getChauffeursWithId(String codeSociete, String chauffeurCode) throws TopiaException;

    /**
     * Recupere le chauffeur a partir du code
     */
    public Chauffeur getChauffeursWithId(String chauffeurCode) throws TopiaException;

    /**
     * Recupere le chauffeur à partir du trigramme
     *
     * @deprecated Code societe is not used any more
     */
    @Deprecated
    public Chauffeur getChauffeursWithTrigramme(String codeSociete, String chauffeurTrigramme) throws TopiaException;

    /**
     * Recupere le chauffeur à partir du trigramme
     */
    public Chauffeur getChauffeursWithTrigramme(String chauffeurTrigramme) throws TopiaException;

    /**
     * Recupere l'ensemble des labels pour d'une categorie
     */
    public List<Label> getLabelListForCategorie(String categorie) throws TopiaException;

    /**
     * Creation des differents label utilise pendant la procedure d'installation
     */
    public void createLabel(Label label) throws TopiaException;

    /**
     * Recupere tous les topiaIds des tours pour un camion
     */
    public List<String> getTopiaIDTourForCamion(String codeSociete, String codeCamion) throws TopiaException;

    /**
     * Recupere seulement les topiaIds des tours créés, modifiés et supprimés depuis 5 jours pour un camion (si synchroNumber != 0)
     */
    public List<TourTypeModif> getModifiedTopiaIDTourForCamionSince(String codeSociete, String codeCamion, Long syncNumber) throws TopiaException;

    /**
     * Recupere le tour à partir d'un topiaId
     */
    public Tour getTourWhithId(String topiaId) throws TopiaException;

    /**
     * Recupere les nouvelles informations de chargement
     */
    public List<LigneProduit> notifyInfoChargement(String topiaIdTour) throws TopiaException;

    /**
     * Supprime le status de notification d'une nouvelle information de chargement
     */
    public void clearInfoChargement(String topiaIdInfoChargement) throws TopiaException;

} //ServiceTour
