package com.cybelia.sandra.services;

import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.trace.CREtape;
import com.cybelia.sandra.entities.trace.CRTour;
import com.cybelia.sandra.entities.trace.CRUsine;
import com.cybelia.sandra.entities.trace.SuiviEtape;
import com.cybelia.sandra.entities.trace.SuiviLigneProduit;
import com.cybelia.sandra.entities.trace.SuiviTour;
import com.cybelia.sandra.entities.trace.SuiviUsine;
import java.util.List;
import javax.ejb.Remote;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.nuiton.topia.TopiaException;

/**
 * Services pour la gestion des traces, c'est a dire la remonte des donnees du
 * PDA vers la base de donnees Sandra.
 *
 * @author julien
 */
@Remote
@RemoteBinding(jndiBinding="ServiceSuiviImpl/remote")
public interface ServiceSuivi {

    /**
     * Permet de mettre a jour un eleveur mais le mets en attente de validation
     */
    void updateEleveur(Eleveur eleveurAttenteValidation) throws TopiaException;

    /**
     * Permet de mettre a jour le point GPS d'un lieu identifie par son code
     */
    void updateGPS(String topiaIdLieu, PointGPS pointGPS) throws TopiaException;

    /**
     * Permet de mettre a jour les infos d'acces a l'eleveur et aux silos
     */
    void updateInfoAcces(String topiaIdEleveur, InfoAccess accesEleveur, List<InfoAccess> accesSilos) throws TopiaException;

    /**
     * Permet de mettre a jour une suivi tour
     */
    String updateSuiviTour(String topiaIdTourCurrent, SuiviTour suiviTour) throws TopiaException;

    /**
     * Permet de mettre a jour une suivi etape
     */
    String updateSuiviEtape(String topiaIdTourCurrent, String topiaIdEtape, SuiviEtape suiviEtape) throws TopiaException;

    /**
     * Permet de mettre a jour une suivi usine
     */
    String updateSuiviUsine(String topiaIdTourCurrent, String codeUsine, int creationOrdreUsine, SuiviUsine suiviUsine) throws TopiaException;

    /**
     * Permet d'enregistrer le compte rendu sur le tour
     */
    void updateCRTour(String topiaIdSuiviTour, CRTour crTour, long updateSynchroNumber) throws TopiaException;

    /**
     * Permet d'enregistrer le compte rendu sur une etape
     */
    void updateCREtape(String topiaIdSuiviEtape, CREtape crEtape) throws TopiaException;

    /**
     * Permet d'enregistrer le compte rendu sur une usine
     */
    void updateCRUsine(String topiaIdSuiviUsine, CRUsine crUsine) throws TopiaException;

    /**
     * Permet de mettre à jour les infos de chargement pour une ligne produit
     */
    void updateSuiviLigneProduit(String topiaIdLigneProduit, String topiaIdSuiviUsine, SuiviLigneProduit suiviLigneProduit) throws TopiaException;

    /**
     * Permet de connaitre le statut affiche sur le web
     */
    int getStatusForTour(String tourTopiaId) throws TopiaException;

    /**
     * Update all sychroStats of user calling this method
     *
     * @param typeConnection {@link com.cybelia.sandra.entities.TypeConnectionEnum}
     * @param gprs true if is an gprs connection, alse is wifi
     * @param sendSize size of send
     * @param recieveSize size of received
     * @param synchroNumber current synch number (is inc on try to synch)
     * @param okSynchroNumber last ok synch number
     * @throws TopiaException if exception occured
     */
    UserIndicateurs updateSynchroStat(int typeConnection, boolean gprs, int sendSize, int recieveSize, int synchroNumber, int okSynchroNumber) throws TopiaException;

} //ServiceSuivi
