/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.cybelia.sandra.services;

import java.io.IOException;
import javax.ejb.Remote;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaNotFoundException;


/**
 * @author letellier
 */
@Remote
@RemoteBinding(jndiBinding="ServiceScheduleImpl/remote")
public interface ServiceSchedule {
    
    /**
     * Envoi la liste des eleveurs sans coordonnees GPS de renseigné
     *
     * @throws Exception if exception occured
     * @param transaction
     */
    public void sendAllEleveurWhithNoGPS(TopiaContext transaction) throws Exception;


    /**
     * Envoi la liste des eleveurs avec des coordonnees GPS mais qui ne sont pas locke
     *
     * @throws Exception if exception occured
     * @param transaction
     */
    public void sendAllEleveurWhithGPSButNotLocked(TopiaContext transaction) throws Exception;

    /**
     * Envoi la liste des camion deconnecter depuis plus de 3j
     *
     * @throws Exception if exception occured
     * @param transaction
     */
    public void sendFindUnconnectedCamion(TopiaContext transaction) throws Exception;

    /**
     * Envoi la liste des eleveurs dangereux
     *
     * @throws Exception if exception occured
     * @param transaction
     */
    public void sendFindDangerousBreeder(TopiaContext transaction) throws Exception;

    /**
     * Envoi la liste des stats utilisateurs
     *
     * @throws Exception if exception occured
     * @param transaction
     */
    public void sendStatNotification(TopiaContext transaction) throws Exception;
    /**
     * Supprime toutes les notifications qui sont en queue
     *
     * @throws Exception if exception occured
     * @param transaction
     */
    public void clearQueue(TopiaContext transaction) throws Exception;

    /*
     * Remise à zéro des nombre de connections des utilisateur
     *
     * @throws Exception if exception occured
     */
    public void razNumberOfConnection(TopiaContext transaction) throws Exception;

    public void injectIBU(String content) throws TopiaNotFoundException, IOException;

    public void injectLabels(String content) throws TopiaNotFoundException, IOException;

    public void injectUsines(String content) throws TopiaNotFoundException, IOException;

    public void injectCamions(String content) throws TopiaNotFoundException, IOException;

    public void injectChauffeurs(String content) throws TopiaNotFoundException, IOException;

    public void injectTransporteurs(String content) throws TopiaNotFoundException, IOException;

    public void injectAutorisations(String content) throws TopiaNotFoundException, IOException;

    public void injectUsers(String content) throws TopiaNotFoundException, IOException;

    public void injectEvents(String content) throws TopiaNotFoundException, IOException;

    public void injectEleveurGPS(String content) throws TopiaNotFoundException, IOException;

    public void injectEleveurDuplicated(String content) throws TopiaNotFoundException, IOException;
}