package com.cybelia.sandra.services;

import com.cybelia.sandra.entities.notifier.Cron;
import com.cybelia.sandra.entities.notifier.Event;
import java.util.List;
import javax.ejb.Remote;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

/**
 * This service is used to send notifications
 */
@Remote
@RemoteBinding(jndiBinding="ServiceNotifierImpl/remote")
public interface ServiceNotifier {

    /**
     * Initialisation du notifier
     * @param transaction
     */
    public void init(TopiaContext transaction);

    /**
     * Notification d'un evenement
     */
    void notifyEvent(String type, String... values) throws TopiaException;

    /**
     * Notification pour un cron a partir de son identifiant, utilse par les jobs
     * de quartz
     */
    void notifyCron(String cronTopiaId) throws TopiaException;

    /**
     * Recupere un evenement
     */
    Event getEvent(TopiaContext transaction, String eventTopiaId) throws TopiaException, LogicException;

    /**
     * Recupere les evenements
     * @param transaction
     */
    List<Event> getEvents(TopiaContext transaction) throws TopiaException, LogicException;

    /**
     * Recupere un cron
     */
    Cron getCron(TopiaContext transaction, String cronTopiaId) throws TopiaException, LogicException;

    /**
     * Recupere le nombre de crons
     * @param transaction
     */
    int getCronsCount(TopiaContext transaction) throws TopiaException, LogicException;

    /**
     * Recupere les crons
     */
    List<Cron> getCrons(TopiaContext transaction, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws TopiaException, LogicException;

    /**
     * Enregistre un cron
     */
    Cron saveCron(TopiaContext transaction, Cron cron) throws TopiaException, LogicException;

    /**
     * Supprime un cron
     */
    void deleteCron(TopiaContext transaction, String cronTopiaId) throws TopiaException, LogicException;

    /**
     * Enregistre un destinataire
     */
    void saveRecepient(TopiaContext transaction, String cronTopiaId, String recipient) throws TopiaException, LogicException;

    /**
     * Supprime un destinataire
     */
    void deleteRecipient(TopiaContext transaction, String cronTopiaId, String recipient) throws TopiaException, LogicException;

    /**
     * Recupere les noms des templates freemarker
     */
    List<String> getTemplates();

    /**
     * Recupere le contenu d'un template
     */
    String getTemplate(String name) throws LogicException;

    /**
     * Enregistre un template freemarker
     */
    void saveTemplate(String name, String template) throws LogicException;

}
