package com.cybelia.sandra.services;

import com.cybelia.sandra.SandraConfig;
import com.cybelia.sandra.SandraConfigHelper;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Une classe avec des methodes utilitaires pour les services.
 * <p/>
 * Cette classe reprend les methodes statiques contenues dans les services EJB qui ne doivent pas
 * en contenir.
 *
 * @author chemit
 * @author letellier
 */
public class ServiceHelper {

    private static final Log log = LogFactory.getLog(ServiceHelper.class);

    public static <S> S newLocalService(Class<S> klass) {
        return newLocalService(klass, null);
    }

    public static <S> S newLocalService(Class<S> klass, Properties env) {
        return newService(klass, env, "Impl/local");
    }

    public static <S> S newRemoteService(Class<S> klass) {
        return newRemoteService(klass, null);
    }

    public static <S> S newRemoteService(Class<S> klass, Properties env) {
        return newService(klass, env, "Impl/remote");
    }

    @SuppressWarnings({"unchecked"})
    public static <S> S newService(Class<S> klass, Properties env, String suffix) {
        try {
            Context context = new InitialContext(env);
//            return (S) context.lookup("sandra/" + klass.getSimpleName() + suffix);
            return (S) context.lookup(klass.getSimpleName() + suffix);
        } catch (NamingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String getSandraName() {
        return SandraConfigHelper.getSandraName(SandraConfig.getConfig());
    }

    public static String getSandraUrl() {
        return SandraConfigHelper.getSandraUrl(SandraConfig.getConfig());
    }
}
