package com.cybelia.sandra.security;

import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.SecurityAssociation;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.topia.taas.entities.TaasUser;

public class SecurityHelper extends NotifierSecurityHelper {

    private static Log log = LogFactory.getLog(SecurityHelper.class);

    protected static TaasUser user;

    /**
     * USE ONLY FOR TEST !
     *
     * @param taasUser to log
     */
    public static void setUser(TaasUser taasUser) {
        user = taasUser;
    }

    public static String getProfilName(String topiaIdProfil) throws TopiaNotFoundException {
        return getProfilClass(TopiaId.getClassName(topiaIdProfil));
    }

    public static String getProfilClass(Class classProfil) {
        return classProfil.getName();
    }

    public static TaasUser getUser() {
        if (user != null) {
            return user;
        }
        try {
            Subject subject = SecurityAssociation.getSubject();
            if (subject == null) {
                return null;
            }
            Set<Object> users = subject.getPrivateCredentials();
            return (TaasUser) CollectionUtils.get(users, 0);
        } catch (Throwable eee) {
            log.error("Cant get users : ", eee);
        }
        if (log.isDebugEnabled()) {
            log.debug("No user found !");
        }
        Set<TaasUser> users = SecurityAssociation.getSubject().getPrivateCredentials(TaasUser.class);
        if (users.isEmpty()) {
            return null;
        }
        TaasUser user = users.iterator().next();
        return user;
    }

    public static String[] getAuthorizations() throws TopiaException {
        return getAuthorizations(getUser());
    }

    public static boolean isAdmin() {
        TaasUser user = getUser();
        return user != null && isAdmin(user);
    }
}
