package com.cybelia.sandra.security;

import com.cybelia.sandra.SandraConfigHelper;
import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.SimpleGroup;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.taas.TaasService;
import org.nuiton.topia.taas.jaas.TaasLoginModule;
import org.nuiton.topia.taas.jaas.TaasPrincipalWrapper;

public class SandraLoginModule extends TaasLoginModule {

    private static Log log = LogFactory.getLog(SandraLoginModule.class);

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler,
                           Map<String, ?> sharedState, Map<String, ?> options) {

        log.info("SandraLoginModule is initialized");
        super.initialize(subject, callbackHandler, sharedState, options);
        if (taasService == null) {
            try {
                TopiaContext rootContext = SandraConfigHelper.getServiceRootContext();
                taasService = rootContext.getService(TaasService.class);
            } catch (Exception e) {
                log.error("Init failed", e);
                throw new SecurityException("init failed", e);
            }
        }
//        SecurityAssociation.setServer();
    }

    @Override
    public boolean commit() throws LoginException {
        try {
            log.info("SandraLoginModule commit");
            super.commit();
            Group roles = new SimpleGroup("Roles");
            for (TaasPrincipalWrapper principal : principals) {
                Group group = new SimpleGroup(principal.getName());
                group.addMember(principal);
                roles.addMember(group);
            }
            subject.getPrincipals().add(roles);
            if (log.isDebugEnabled()) {
                log.debug("SandraLoginModule commit with subject " + subject);
            }
        } catch (Throwable eee) {
            log.error("Cant commit : ", eee);
            throw new LoginException(eee.getMessage());
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        log.info("SandraLoginModule logout");
//        SecurityAssociation.clear();
        return super.logout();
    }
}
