package com.cybelia.sandra.security;

import com.cybelia.sandra.services.LogicException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.persistence.TopiaEntity;

public class ProfilManager extends NotifierProfilManager {

    private static Log log = LogFactory.getLog(ProfilManager.class);

    /**
     * Recupere une entite a partir du topiaId
     */
    public static TopiaEntity getTopiaEntity(TopiaContext transaction, String topiaId) throws TopiaNotFoundException, TopiaException {
        return getTopiaEntity(transaction, SecurityHelper.getUser(), topiaId);
    }

    public static <T> int count(TopiaContext context, Class<? extends TopiaEntity> classSearch,
                                String query, Object... args) throws TopiaException {

        List<?> result = null;
        if (SecurityHelper.isAdmin()) {
            result = context.findAll(query, args);
        } else {
            result = find(context, classSearch, SecurityHelper.getUser(), query, args);
        }

        Object o = result.get(0);
        if (log.isDebugEnabled()) {
            log.debug("count " + query + " : " + o);
        }
        return Integer.valueOf("" + o);
    }

    public static <T> List<T> find(TopiaContext context, Class<? extends TopiaEntity> classSearch,
                                   String query, Object... args) throws TopiaException {

        List<T> result = null;

        if (SecurityHelper.isAdmin()) {
            result = context.findAll(query, args);
        } else {
            result = find(context, classSearch, SecurityHelper.getUser(), query, args);
        }

        return result;
    }

    public static <T> T findUnique(String errorI18nKey, TopiaContext context, Class<? extends TopiaEntity> classSearch,
                                   String query, Object... args) throws TopiaException, LogicException {
        List<T> result = find(context, classSearch, query, args);
        if (result == null || result.isEmpty()) {
            throw new LogicException(errorI18nKey);
        }
        return result.get(0);
    }

    public static <T> List<T> findWithBounds(TopiaContext context, Class<? extends TopiaEntity> classSearch,
                                             String query, int startIndex, int endIndex, Object... args) throws TopiaException {

        List<T> result = null;

        if (SecurityHelper.isAdmin()) {
            result = context.find(query, startIndex, endIndex, args);
        } else {
            result = findWithBounds(context, classSearch, SecurityHelper.getUser(), query, startIndex, endIndex, args);
        }

        return result;
    }

}
