package com.cybelia.sandra;

import com.cybelia.sandra.security.NoSecurityOnLoad;
import com.cybelia.sandra.security.SandraSubjectFinder;
import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.taas.TaasService;
import org.nuiton.util.ApplicationConfig;

/**
 * @author sletellier
 */
public class SandraConfigHelper extends SandraSchedulerConfigHelper {

    /**
     * Logger.
     */
    public static final Log log = LogFactory.getLog(SandraConfigHelper.class);

    public static Properties getServiceTopiaProperties(ApplicationConfig config) throws IOException {

        Properties properties = getSchedulerTopiaProperties(config);

        // Add security service config
        properties.put(TaasService.TOPIA_SERVICE_TAAS, TaasService.class.getName());
        properties.put(TaasService.SERVICE_EVENT, NoSecurityOnLoad.class.getName());
        properties.put(TaasService.SERVICE_SUBJECT, SandraSubjectFinder.class.getName());

        return properties;
    }

    public static String getGoogleMapKey(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.GOOGLE_MAP_KEY.key);
    }

    public static String getSandraVersion(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_VERSION.key);
    }

    static public Date getPreviousRAZDate(ApplicationConfig config) throws ParseException {
        Date nextDatefromProperies = getNextDatefromProperies(config, SchedulerJobFactory.RazNumberOfConnection.PATTERN);
        Calendar cal = Calendar.getInstance();
        if (nextDatefromProperies != null){
            cal.setTime(nextDatefromProperies);
            cal.add(Calendar.MONTH, -1);
        }
        return cal.getTime();
    }

    public static String getNoteDir(ApplicationConfig config) {
        return config.getOption(SandraConfig.SandraOption.SANDRA_NOTE_DIR.key);
    }

    public static TopiaContext getServiceRootContext() throws IOException, TopiaNotFoundException {
        ApplicationConfig config = SandraConfig.getConfig();
        Properties serviceTopiaProperties = SandraConfigHelper.getServiceTopiaProperties(config);
        return TopiaContextFactory.getContext(serviceTopiaProperties);
    }
}
