package com.cybelia.sandra.entities.trace;

import com.cybelia.sandra.SandraEntityEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class CREtapeDAOAbstract<E extends CREtape> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)CREtape.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.CREtape;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<SuiviEtape> list = getContext()
                                                    .getDAO(SuiviEtape.class)
                                                    .findAllByProperties(SuiviEtape.PROPERTY_C_RETAPE, entity);
                                            for (SuiviEtape item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getcREtape())) {
                                                    item.setcREtape(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByEtapeHeureLivraison(Date v) throws TopiaException {
        E result = findByProperty(CREtape.PROPERTY_ETAPE_HEURE_LIVRAISON, v);
        return result;
    }

    public List<E> findAllByEtapeHeureLivraison(Date v) throws TopiaException {
        List<E> result = findAllByProperty(CREtape.PROPERTY_ETAPE_HEURE_LIVRAISON, v);
        return result;
    }

    public E findByPurge(int v) throws TopiaException {
        E result = findByProperty(CREtape.PROPERTY_PURGE, v);
        return result;
    }

    public List<E> findAllByPurge(int v) throws TopiaException {
        List<E> result = findAllByProperty(CREtape.PROPERTY_PURGE, v);
        return result;
    }

    public E findByLivraisonStatut(String v) throws TopiaException {
        E result = findByProperty(CREtape.PROPERTY_LIVRAISON_STATUT, v);
        return result;
    }

    public List<E> findAllByLivraisonStatut(String v) throws TopiaException {
        List<E> result = findAllByProperty(CREtape.PROPERTY_LIVRAISON_STATUT, v);
        return result;
    }

    public E findByCommentaireLivraison(String v) throws TopiaException {
        E result = findByProperty(CREtape.PROPERTY_COMMENTAIRE_LIVRAISON, v);
        return result;
    }

    public List<E> findAllByCommentaireLivraison(String v) throws TopiaException {
        List<E> result = findAllByProperty(CREtape.PROPERTY_COMMENTAIRE_LIVRAISON, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == SuiviEtape.class) {
            SuiviEtapeDAO dao = (SuiviEtapeDAO)
                getContext().getDAO(SuiviEtape.class);
            tmp = dao.findAllBycREtape(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(SuiviEtape.class, entity);
        if (!list.isEmpty()) {
            result.put(SuiviEtape.class, list);
        }

        return result;
    }

} //CREtapeDAOAbstract<E extends CREtape>
