package com.cybelia.sandra.entities.notifier;

import com.cybelia.sandra.SandraEntityEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class CronDAOAbstract<E extends Cron> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Cron.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Cron;
    }

    @Override
    public void delete(E entity) throws TopiaException {
        {
            List<Queue> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from queue main, cron_queue secondary " +
                    "where main.topiaid=secondary.queue" +
                    " and secondary.cron='" + entity.getTopiaId() + "'")
                    .addEntity("main", com.cybelia.sandra.SandraDAOHelper.getImplementationClass(Queue.class)).list();

            for (Queue item : list) {
                item.removeCron(entity);
            }
        }

        super.delete(entity);
    }

    public E findByLabel(String v) throws TopiaException {
        E result = findByProperty(Cron.PROPERTY_LABEL, v);
        return result;
    }

    public List<E> findAllByLabel(String v) throws TopiaException {
        List<E> result = findAllByProperty(Cron.PROPERTY_LABEL, v);
        return result;
    }

    public E findByDateStart(Date v) throws TopiaException {
        E result = findByProperty(Cron.PROPERTY_DATE_START, v);
        return result;
    }

    public List<E> findAllByDateStart(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Cron.PROPERTY_DATE_START, v);
        return result;
    }

    public E findByDateEnd(Date v) throws TopiaException {
        E result = findByProperty(Cron.PROPERTY_DATE_END, v);
        return result;
    }

    public List<E> findAllByDateEnd(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Cron.PROPERTY_DATE_END, v);
        return result;
    }

    public E findByTemplate(String v) throws TopiaException {
        E result = findByProperty(Cron.PROPERTY_TEMPLATE, v);
        return result;
    }

    public List<E> findAllByTemplate(String v) throws TopiaException {
        List<E> result = findAllByProperty(Cron.PROPERTY_TEMPLATE, v);
        return result;
    }

    public E findByExpression(String v) throws TopiaException {
        E result = findByProperty(Cron.PROPERTY_EXPRESSION, v);
        return result;
    }

    public List<E> findAllByExpression(String v) throws TopiaException {
        List<E> result = findAllByProperty(Cron.PROPERTY_EXPRESSION, v);
        return result;
    }

    public E findContainsRecipients(String v) throws TopiaException {
        E result = findContains(Cron.PROPERTY_RECIPIENTS, v);
        return result;
    }

    public List<E> findAllContainsRecipients(String v) throws TopiaException {
        List<E> result = findAllContains(Cron.PROPERTY_RECIPIENTS, v);
        return result;
    }

    public E findByEnable(boolean v) throws TopiaException {
        E result = findByProperty(Cron.PROPERTY_ENABLE, v);
        return result;
    }

    public List<E> findAllByEnable(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Cron.PROPERTY_ENABLE, v);
        return result;
    }

    public E findByAuthor(String v) throws TopiaException {
        E result = findByProperty(Cron.PROPERTY_AUTHOR, v);
        return result;
    }

    public List<E> findAllByAuthor(String v) throws TopiaException {
        List<E> result = findAllByProperty(Cron.PROPERTY_AUTHOR, v);
        return result;
    }

    public E findByEvent(Event v) throws TopiaException {
        E result = findByProperty(Cron.PROPERTY_EVENT, v);
        return result;
    }

    public List<E> findAllByEvent(Event v) throws TopiaException {
        List<E> result = findAllByProperty(Cron.PROPERTY_EVENT, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Queue.class) {
            QueueDAO dao = (QueueDAO)
                getContext().getDAO(Queue.class);
            tmp = dao.findAllContainsCron(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Queue.class, entity);
        if (!list.isEmpty()) {
            result.put(Queue.class, list);
        }

        return result;
    }

} //CronDAOAbstract<E extends Cron>
