package com.cybelia.sandra.entities.notifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class CronAbstract extends TopiaEntityAbstract implements Cron {

    /**
     * Nom de l'attribut en BD : label
     */
    protected String label;

    /**
     * Nom de l'attribut en BD : dateStart
     */
    protected Date dateStart;

    /**
     * Nom de l'attribut en BD : dateEnd
     */
    protected Date dateEnd;

    /**
     * Nom de l'attribut en BD : template
     */
    protected String template;

    /**
     * Nom de l'attribut en BD : expression
     */
    protected String expression;

    /**
     * Nom de l'attribut en BD : recipients
     */
    protected Collection<String> recipients;

    /**
     * Nom de l'attribut en BD : enable
     */
    protected boolean enable;

    /**
     * Nom de l'attribut en BD : author
     */
    protected String author;

    /**
     * Nom de l'attribut en BD : event
     */
    protected Event event;

    private static final long serialVersionUID = 3703192782827501112L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_LABEL, String.class, label);
        visitor.visit(this, PROPERTY_DATE_START, Date.class, dateStart);
        visitor.visit(this, PROPERTY_DATE_END, Date.class, dateEnd);
        visitor.visit(this, PROPERTY_TEMPLATE, String.class, template);
        visitor.visit(this, PROPERTY_EXPRESSION, String.class, expression);
        visitor.visit(this, PROPERTY_RECIPIENTS, Collection.class, String.class, recipients);
        visitor.visit(this, PROPERTY_ENABLE, boolean.class, enable);
        visitor.visit(this, PROPERTY_AUTHOR, String.class, author);
        visitor.visit(this, PROPERTY_EVENT, Event.class, event);
        visitor.end(this);
    }

    @Override
    public void setLabel(String label) {
        String oldValue = this.label;
        fireOnPreWrite(PROPERTY_LABEL, oldValue, label);
        this.label = label;
        fireOnPostWrite(PROPERTY_LABEL, oldValue, label);
    }

    @Override
    public String getLabel() {
        fireOnPreRead(PROPERTY_LABEL, label);
        String result = this.label;
        fireOnPostRead(PROPERTY_LABEL, label);
        return result;
    }

    @Override
    public void setDateStart(Date dateStart) {
        Date oldValue = this.dateStart;
        fireOnPreWrite(PROPERTY_DATE_START, oldValue, dateStart);
        this.dateStart = dateStart;
        fireOnPostWrite(PROPERTY_DATE_START, oldValue, dateStart);
    }

    @Override
    public Date getDateStart() {
        fireOnPreRead(PROPERTY_DATE_START, dateStart);
        Date result = this.dateStart;
        fireOnPostRead(PROPERTY_DATE_START, dateStart);
        return result;
    }

    @Override
    public void setDateEnd(Date dateEnd) {
        Date oldValue = this.dateEnd;
        fireOnPreWrite(PROPERTY_DATE_END, oldValue, dateEnd);
        this.dateEnd = dateEnd;
        fireOnPostWrite(PROPERTY_DATE_END, oldValue, dateEnd);
    }

    @Override
    public Date getDateEnd() {
        fireOnPreRead(PROPERTY_DATE_END, dateEnd);
        Date result = this.dateEnd;
        fireOnPostRead(PROPERTY_DATE_END, dateEnd);
        return result;
    }

    @Override
    public void setTemplate(String template) {
        String oldValue = this.template;
        fireOnPreWrite(PROPERTY_TEMPLATE, oldValue, template);
        this.template = template;
        fireOnPostWrite(PROPERTY_TEMPLATE, oldValue, template);
    }

    @Override
    public String getTemplate() {
        fireOnPreRead(PROPERTY_TEMPLATE, template);
        String result = this.template;
        fireOnPostRead(PROPERTY_TEMPLATE, template);
        return result;
    }

    @Override
    public void setExpression(String expression) {
        String oldValue = this.expression;
        fireOnPreWrite(PROPERTY_EXPRESSION, oldValue, expression);
        this.expression = expression;
        fireOnPostWrite(PROPERTY_EXPRESSION, oldValue, expression);
    }

    @Override
    public String getExpression() {
        fireOnPreRead(PROPERTY_EXPRESSION, expression);
        String result = this.expression;
        fireOnPostRead(PROPERTY_EXPRESSION, expression);
        return result;
    }

    @Override
    public void addRecipients(String recipients) {
        fireOnPreWrite(PROPERTY_RECIPIENTS, null, recipients);
        if (this.recipients == null) {
            this.recipients = new ArrayList<String>();
        }

        this.recipients.add(recipients);
        fireOnPostWrite(PROPERTY_RECIPIENTS, this.recipients.size(), null, recipients);
    }

    @Override
    public void addAllRecipients(Collection<String> recipients) {
        if (recipients == null) {
            return;
        }
        for (String item : recipients) {
            addRecipients(item);
        }
    }

    @Override
    public void setRecipients(Collection<String> recipients) {
        // Copy elements to keep data for fire with new reference
        Collection<String> oldValue = this.recipients != null ? new ArrayList<String>(this.recipients) : null;
        fireOnPreWrite(PROPERTY_RECIPIENTS, oldValue, recipients);
        this.recipients = recipients;
        fireOnPostWrite(PROPERTY_RECIPIENTS, oldValue, recipients);
    }

    @Override
    public void removeRecipients(String recipients) {
        fireOnPreWrite(PROPERTY_RECIPIENTS, recipients, null);
        if (this.recipients == null || !this.recipients.remove(recipients)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_RECIPIENTS, this.recipients.size() + 1, recipients, null);
    }

    @Override
    public void clearRecipients() {
        if (this.recipients == null) {
            return;
        }
        Collection<String> oldValue = new ArrayList<String>(this.recipients);
        fireOnPreWrite(PROPERTY_RECIPIENTS, oldValue, this.recipients);
        this.recipients.clear();
        fireOnPostWrite(PROPERTY_RECIPIENTS, oldValue, this.recipients);
    }

    @Override
    public Collection<String> getRecipients() {
        return recipients;
    }

    @Override
    public int sizeRecipients() {
        if (recipients == null) {
            return 0;
        }
        return recipients.size();
    }

    @Override
    public boolean isRecipientsEmpty() {
        int size = sizeRecipients();
        return size == 0;
    }

    @Override
    public void setEnable(boolean enable) {
        boolean oldValue = this.enable;
        fireOnPreWrite(PROPERTY_ENABLE, oldValue, enable);
        this.enable = enable;
        fireOnPostWrite(PROPERTY_ENABLE, oldValue, enable);
    }

    @Override
    public boolean isEnable() {
        fireOnPreRead(PROPERTY_ENABLE, enable);
        boolean result = this.enable;
        fireOnPostRead(PROPERTY_ENABLE, enable);
        return result;
    }

    @Override
    public boolean getEnable() {
        fireOnPreRead(PROPERTY_ENABLE, enable);
        boolean result = this.enable;
        fireOnPostRead(PROPERTY_ENABLE, enable);
        return result;
    }

    @Override
    public void setAuthor(String author) {
        String oldValue = this.author;
        fireOnPreWrite(PROPERTY_AUTHOR, oldValue, author);
        this.author = author;
        fireOnPostWrite(PROPERTY_AUTHOR, oldValue, author);
    }

    @Override
    public String getAuthor() {
        fireOnPreRead(PROPERTY_AUTHOR, author);
        String result = this.author;
        fireOnPostRead(PROPERTY_AUTHOR, author);
        return result;
    }

    @Override
    public void setEvent(Event event) {
        Event oldValue = this.event;
        fireOnPreWrite(PROPERTY_EVENT, oldValue, event);
        this.event = event;
        fireOnPostWrite(PROPERTY_EVENT, oldValue, event);
    }

    @Override
    public Event getEvent() {
        fireOnPreRead(PROPERTY_EVENT, event);
        Event result = this.event;
        fireOnPostRead(PROPERTY_EVENT, event);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_LABEL, this.label).
            append(PROPERTY_DATE_START, this.dateStart).
            append(PROPERTY_DATE_END, this.dateEnd).
            append(PROPERTY_TEMPLATE, this.template).
            append(PROPERTY_EXPRESSION, this.expression).
            append(PROPERTY_RECIPIENTS, this.recipients).
            append(PROPERTY_ENABLE, this.enable).
            append(PROPERTY_AUTHOR, this.author).
            append(PROPERTY_EVENT, this.event).
         toString();
        return result;
    }

} //CronAbstract
