package com.cybelia.sandra.entities;

import com.cybelia.sandra.SandraEntityEnum;
import com.cybelia.sandra.entities.trace.SuiviUsine;
import com.cybelia.sandra.entities.trace.SuiviUsineDAO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class UsineDAOAbstract<E extends Usine> extends LieuDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Usine.class;
    }

    @Override
    public SandraEntityEnum getTopiaEntityEnum() {
        return SandraEntityEnum.Usine;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<SuiviUsine> list = getContext()
                                                    .getDAO(SuiviUsine.class)
                                                    .findAllByProperties(SuiviUsine.PROPERTY_USINE, entity);
                                            for (SuiviUsine item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getUsine())) {
                                                    item.setUsine(null);
                                                }
                        
                    }
                }

                                        {
                                        List<LigneProduit> list = getContext()
                                                    .getDAO(LigneProduit.class)
                                                    .findAllByProperties(LigneProduit.PROPERTY_USINE, entity);
                                            for (LigneProduit item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getUsine())) {
                                                    item.setUsine(null);
                                                }
                        
                    }
                }

                                        {
                                        List<ChargementUsineConfig> list = getContext()
                                                    .getDAO(ChargementUsineConfig.class)
                                                    .findAllByProperties(ChargementUsineConfig.PROPERTY_USINE, entity);
                                            for (ChargementUsineConfig item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getUsine())) {
                                                    item.setUsine(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByNaturalId(String code) throws TopiaException {
        return findByProperties(Usine.PROPERTY_CODE, code);
    }

    public boolean existByNaturalId(String code) throws TopiaException {
        return existByProperties(Usine.PROPERTY_CODE, code);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param code 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(String code) throws TopiaException {
        return create(Usine.PROPERTY_CODE, code);
    }

    public E createByNaturalId(String code) throws TopiaException {
        return create(Usine.PROPERTY_CODE, code);
    }

    public E createByNotNull(String code) throws TopiaException {
        return create(Usine.PROPERTY_CODE, code);
    }

    public E findByAdresse(String v) throws TopiaException {
        E result = findByProperty(Usine.PROPERTY_ADRESSE, v);
        return result;
    }

    public List<E> findAllByAdresse(String v) throws TopiaException {
        List<E> result = findAllByProperty(Usine.PROPERTY_ADRESSE, v);
        return result;
    }

    public E findByCodePostal(String v) throws TopiaException {
        E result = findByProperty(Usine.PROPERTY_CODE_POSTAL, v);
        return result;
    }

    public List<E> findAllByCodePostal(String v) throws TopiaException {
        List<E> result = findAllByProperty(Usine.PROPERTY_CODE_POSTAL, v);
        return result;
    }

    public E findByVille(String v) throws TopiaException {
        E result = findByProperty(Usine.PROPERTY_VILLE, v);
        return result;
    }

    public List<E> findAllByVille(String v) throws TopiaException {
        List<E> result = findAllByProperty(Usine.PROPERTY_VILLE, v);
        return result;
    }

    public E findByCodeINSEE(String v) throws TopiaException {
        E result = findByProperty(Usine.PROPERTY_CODE_INSEE, v);
        return result;
    }

    public List<E> findAllByCodeINSEE(String v) throws TopiaException {
        List<E> result = findAllByProperty(Usine.PROPERTY_CODE_INSEE, v);
        return result;
    }

    public E findByBlockGPSModif(boolean v) throws TopiaException {
        E result = findByProperty(Usine.PROPERTY_BLOCK_GPSMODIF, v);
        return result;
    }

    public List<E> findAllByBlockGPSModif(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Usine.PROPERTY_BLOCK_GPSMODIF, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == LigneProduit.class) {
            LigneProduitDAO dao = (LigneProduitDAO)
                getContext().getDAO(LigneProduit.class);
            tmp = dao.findAllByUsine(entity);
            result.addAll(tmp);
        }

        if (type == SuiviUsine.class) {
            SuiviUsineDAO dao = (SuiviUsineDAO)
                getContext().getDAO(SuiviUsine.class);
            tmp = dao.findAllByUsine(entity);
            result.addAll(tmp);
        }

        if (type == ChargementUsineConfig.class) {
            ChargementUsineConfigDAO dao = (ChargementUsineConfigDAO)
                getContext().getDAO(ChargementUsineConfig.class);
            tmp = dao.findAllByUsine(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);

        List<? extends TopiaEntity> list;

        list = findUsages(LigneProduit.class, entity);
        if (!list.isEmpty()) {
            result.put(LigneProduit.class, list);
        }

        list = findUsages(SuiviUsine.class, entity);
        if (!list.isEmpty()) {
            result.put(SuiviUsine.class, list);
        }

        list = findUsages(ChargementUsineConfig.class, entity);
        if (!list.isEmpty()) {
            result.put(ChargementUsineConfig.class, list);
        }

        return result;
    }

} //UsineDAOAbstract<E extends Usine>
