package com.cybelia.sandra.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class NoteAbstract extends TopiaEntityAbstract implements Note {

    /**
     * Nom de l'attribut en BD : nom
     */
    protected String nom;

    /**
     * Nom de l'attribut en BD : description
     */
    protected String description;

    /**
     * Nom de l'attribut en BD : contentType
     */
    protected String contentType;

    /**
     * Nom de l'attribut en BD : eleveur
     */
    protected Eleveur eleveur;

    private static final long serialVersionUID = 7149009417737943349L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NOM, String.class, nom);
        visitor.visit(this, PROPERTY_DESCRIPTION, String.class, description);
        visitor.visit(this, PROPERTY_CONTENT_TYPE, String.class, contentType);
        visitor.visit(this, PROPERTY_ELEVEUR, Eleveur.class, eleveur);
        visitor.end(this);
    }

    @Override
    public void setNom(String nom) {
        String oldValue = this.nom;
        fireOnPreWrite(PROPERTY_NOM, oldValue, nom);
        this.nom = nom;
        fireOnPostWrite(PROPERTY_NOM, oldValue, nom);
    }

    @Override
    public String getNom() {
        fireOnPreRead(PROPERTY_NOM, nom);
        String result = this.nom;
        fireOnPostRead(PROPERTY_NOM, nom);
        return result;
    }

    @Override
    public void setDescription(String description) {
        String oldValue = this.description;
        fireOnPreWrite(PROPERTY_DESCRIPTION, oldValue, description);
        this.description = description;
        fireOnPostWrite(PROPERTY_DESCRIPTION, oldValue, description);
    }

    @Override
    public String getDescription() {
        fireOnPreRead(PROPERTY_DESCRIPTION, description);
        String result = this.description;
        fireOnPostRead(PROPERTY_DESCRIPTION, description);
        return result;
    }

    @Override
    public void setContentType(String contentType) {
        String oldValue = this.contentType;
        fireOnPreWrite(PROPERTY_CONTENT_TYPE, oldValue, contentType);
        this.contentType = contentType;
        fireOnPostWrite(PROPERTY_CONTENT_TYPE, oldValue, contentType);
    }

    @Override
    public String getContentType() {
        fireOnPreRead(PROPERTY_CONTENT_TYPE, contentType);
        String result = this.contentType;
        fireOnPostRead(PROPERTY_CONTENT_TYPE, contentType);
        return result;
    }

    @Override
    public void setEleveur(Eleveur eleveur) {
        Eleveur oldValue = this.eleveur;
        fireOnPreWrite(PROPERTY_ELEVEUR, oldValue, eleveur);
        this.eleveur = eleveur;
        fireOnPostWrite(PROPERTY_ELEVEUR, oldValue, eleveur);
    }

    @Override
    public Eleveur getEleveur() {
        fireOnPreRead(PROPERTY_ELEVEUR, eleveur);
        Eleveur result = this.eleveur;
        fireOnPostRead(PROPERTY_ELEVEUR, eleveur);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NOM, this.nom).
            append(PROPERTY_DESCRIPTION, this.description).
            append(PROPERTY_CONTENT_TYPE, this.contentType).
         toString();
        return result;
    }

} //NoteAbstract
