/*
 * Decompiled with CFR 0.152.
 */
package com.github.approval.utils;

import com.github.approval.utils.FileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;

public class DefaultFileSystemUtils
implements FileSystemUtils {
    private static final Logger LOG = Logger.getLogger(DefaultFileSystemUtils.class.getName());

    @Override
    public void write(Path path, byte[] value) throws IOException {
        Files.write(path, value, new OpenOption[0]);
    }

    @Override
    public byte[] readFully(Path path) throws IOException {
        return Files.readAllBytes(path);
    }

    @Override
    public void move(Path path, Path filePath) throws IOException {
        if (Files.exists(filePath, new LinkOption[0])) {
            Files.delete(filePath);
        }
        Files.move(path, filePath, new CopyOption[0]);
    }

    @Override
    public void createDirectories(File directory) throws IOException {
        LOG.info("Creating directory " + directory);
        if (!directory.mkdirs()) {
            throw new IOException("Couldn't create directory " + directory);
        }
    }

    @Override
    public void touch(Path pathToCreate) throws IOException {
        Files.createFile(pathToCreate, new FileAttribute[0]);
    }
}

