/*
 * Decompiled with CFR 0.152.
 */
package com.github.approval.converters;

import com.github.approval.converters.AbstractStringConverter;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;

public class ReflectiveBeanConverter<T>
extends AbstractStringConverter<T> {
    @Override
    @Nonnull
    protected String getStringForm(T value) {
        Field[] fields = value.getClass().getDeclaredFields();
        StringBuilder builder = new StringBuilder();
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(value);
                if (fieldValue == null) continue;
                builder.append(field.getName()).append(" = ").append(fieldValue).append("\n");
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Couldn't access field " + field.getName());
            }
        }
        return builder.toString();
    }
}

