/*
 * Decompiled with CFR 0.152.
 */
package com.github.miachm.sods;

class ColumnStyle {
    private Double width;
    private static final double EQUIVALENCE_CM = 0.1;
    private static final double EQUIVALENCE_PX = 0.264583333;
    private static final double EQUIVALENCE_IN = 0.0254;
    private static final double EQUIVALENCE_PT = 3.5277777777777776E-4;
    private static final double EQUIVALENCE_PC = 0.30479999999999996;

    ColumnStyle() {
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    void setWidth(String width) {
        this.width = ColumnStyle.getValue(width);
    }

    public static Double getValue(String value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty() || value.equals("0")) {
            return 0.0;
        }
        if (value.length() > 2) {
            double number = Double.parseDouble(value.substring(0, value.length() - 2));
            if (value.endsWith("mm")) {
                return number;
            }
            if (value.endsWith("cm")) {
                return number * 0.1;
            }
            if (value.endsWith("in")) {
                return number * 0.0254;
            }
            if (value.endsWith("pt")) {
                return number * 3.5277777777777776E-4;
            }
            if (value.endsWith("pc")) {
                return number * 0.30479999999999996;
            }
            if (value.endsWith("px")) {
                return number * 0.264583333;
            }
            throw new IllegalArgumentException("Unit not recognized");
        }
        throw new IllegalArgumentException("A unit is needed");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStyle that = (ColumnStyle)o;
        return this.width != null ? this.width.equals(that.width) : that.width == null;
    }

    public int hashCode() {
        return this.width != null ? this.width.hashCode() : 0;
    }

    public String toString() {
        return "ColumnStyle{width=" + this.width + '}';
    }
}

