/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.services.javascript;

import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.StylesheetLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JQueryDateFieldStack
implements JavaScriptStack {
    private final ThreadLocale threadLocale;
    private final AssetSource assetSource;
    private final boolean compactJSON;
    private final boolean productionMode;
    private final TypeCoercer typeCoercer;
    private final SymbolSource symbolSource;

    public JQueryDateFieldStack(ThreadLocale threadLocale, @Symbol(value="tapestry.compact-json") boolean compactJSON, @Symbol(value="tapestry.production-mode") boolean productionMode, AssetSource assetSource, TypeCoercer typeCoercer, SymbolSource symbolSource) {
        this.threadLocale = threadLocale;
        this.assetSource = assetSource;
        this.compactJSON = compactJSON;
        this.typeCoercer = typeCoercer;
        this.symbolSource = symbolSource;
        this.productionMode = productionMode;
    }

    public String getInitialization() {
        Locale locale = this.threadLocale.getLocale();
        JSONObject spec = new JSONObject();
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        spec.put("months", (Object)new JSONArray((Object[])symbols.getMonths()));
        StringBuilder days = new StringBuilder();
        String[] weekdays = symbols.getWeekdays();
        Calendar c = Calendar.getInstance(locale);
        int firstDay = c.getFirstDayOfWeek();
        for (int i = 2; i <= 7; ++i) {
            days.append(weekdays[i].substring(0, 1));
        }
        days.append(weekdays[1].substring(0, 1));
        spec.put("days", (Object)days.toString().toLowerCase(locale));
        spec.put("firstDay", (Object)(firstDay - 1));
        spec.put("language", (Object)locale.getLanguage());
        return String.format("Tapestry.DateField.initLocalization(%s);", spec.toString(this.compactJSON));
    }

    public List<Asset> getJavaScriptLibraries() {
        String jQueryUIPath = this.symbolSource.valueForSymbol("jquery.ui.path");
        if (!jQueryUIPath.endsWith("/")) {
            jQueryUIPath = jQueryUIPath + "/";
        }
        ArrayList<Asset> javaScriptStack = new ArrayList<Asset>();
        javaScriptStack.add(this.assetSource.getClasspathAsset(String.format("%s%s/jquery.ui.datepicker%s.js", jQueryUIPath, !this.productionMode ? "/minified" : "", !this.productionMode ? ".min" : "")));
        Asset datePickerI18nAsset = this.getLocaleAsset(this.threadLocale.getLocale(), jQueryUIPath);
        if (datePickerI18nAsset != null) {
            javaScriptStack.add(datePickerI18nAsset);
        }
        javaScriptStack.add(this.assetSource.getExpandedAsset("${assets.path}/components/datefield/datefield.js"));
        return javaScriptStack;
    }

    private Asset getLocaleAsset(Locale locale, String jQueryUIPath) {
        String prefix = String.format("%s/i18n/jquery.ui.datepicker-%s", jQueryUIPath, locale.getLanguage());
        Resource withCountryExtension = (Resource)this.typeCoercer.coerce((Object)String.format("%s-%s.js", prefix, locale.getCountry()), Resource.class);
        if (withCountryExtension.exists()) {
            return this.assetSource.getClasspathAsset(withCountryExtension.getPath());
        }
        Resource withLanguageExtension = (Resource)this.typeCoercer.coerce((Object)String.format("%s.js", prefix), Resource.class);
        if (withLanguageExtension.exists()) {
            return this.assetSource.getClasspathAsset(withLanguageExtension.getPath());
        }
        return null;
    }

    public List<StylesheetLink> getStylesheets() {
        return Collections.emptyList();
    }

    public List<String> getStacks() {
        return Collections.emptyList();
    }
}

