/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfNumber;
import java.util.LinkedList;
import java.util.List;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PdfTextArray {
    private List<Object> arrayList = new LinkedList<Object>();
    private String lastStr;
    private Float lastNum;
    private boolean isRTL = false;

    public PdfTextArray(String str) {
        this.add(str);
    }

    public PdfTextArray() {
    }

    public void add(PdfNumber number) {
        this.add((float)number.doubleValue());
    }

    public void add(float number) {
        if (number != 0.0f) {
            if (this.lastNum != null) {
                this.lastNum = Float.valueOf(number + this.lastNum.floatValue());
                if (this.lastNum.floatValue() != 0.0f) {
                    this.replaceLast(this.lastNum);
                } else {
                    this.arrayList.remove(this.isRTL ? 0 : this.arrayList.size() - 1);
                }
            } else {
                this.lastNum = Float.valueOf(number);
                if (this.isRTL) {
                    this.arrayList.add(0, this.lastNum);
                } else {
                    this.arrayList.add(this.lastNum);
                }
            }
            this.lastStr = null;
        }
    }

    public void add(String str) {
        if (this.isRTL) {
            str = new StringBuffer(str).reverse().toString();
        }
        if (str.length() > 0) {
            if (this.lastStr != null) {
                this.lastStr = this.isRTL ? str + this.lastStr : this.lastStr + str;
                this.replaceLast(this.lastStr);
            } else {
                this.lastStr = str;
                if (this.isRTL) {
                    this.arrayList.add(0, this.lastStr);
                } else {
                    this.arrayList.add(this.lastStr);
                }
            }
            this.lastNum = null;
        }
    }

    List getArrayList() {
        return this.arrayList;
    }

    private void replaceLast(Object obj) {
        if (this.isRTL) {
            this.arrayList.set(0, obj);
        } else {
            this.arrayList.set(this.arrayList.size() - 1, obj);
        }
    }

    public void setRTL(boolean isRTL) {
        this.isRTL = isRTL;
    }

    public boolean getRTL() {
        return this.isRTL;
    }
}

