/*
 * Decompiled with CFR 0.152.
 */
package smile.vq;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Stream;
import smile.sort.HeapSelect;
import smile.vq.VectorQuantizer;
import smile.vq.hebb.Edge;
import smile.vq.hebb.Neuron;

public class GrowingNeuralGas
implements VectorQuantizer {
    private static final long serialVersionUID = 2L;
    private final int d;
    private int t = 0;
    private double epsBest = 0.2;
    private double epsNeighbor = 0.006;
    private int edgeLifetime = 50;
    private int lambda = 100;
    private double alpha = 0.5;
    private double beta = 0.995;
    private final ArrayList<Neuron> neurons = new ArrayList();

    public GrowingNeuralGas(int d) {
        this.d = d;
    }

    public GrowingNeuralGas(int d, double epsBest, double epsNeighbor, int edgeLifetime, int lambda, double alpha, double beta) {
        this.d = d;
        this.epsBest = epsBest;
        this.epsNeighbor = epsNeighbor;
        this.edgeLifetime = edgeLifetime;
        this.lambda = lambda;
        this.alpha = alpha;
        this.beta = beta;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(double[] x) {
        ++this.t;
        if (this.neurons.size() < 2) {
            this.neurons.add(new Neuron((double[])x.clone()));
            return;
        }
        ((Stream)this.neurons.stream().parallel()).forEach(neuron -> neuron.distance(x));
        HeapSelect heap = new HeapSelect(Neuron.class, 2);
        for (Neuron neuron2 : this.neurons) {
            heap.add((Comparable)neuron2);
        }
        Neuron s1 = (Neuron)heap.get(0);
        Neuron s2 = (Neuron)heap.get(1);
        s1.update(x, this.epsBest);
        s1.counter += s1.distance * s1.distance;
        s1.age();
        boolean addEdge = true;
        for (Edge edge : s1.edges) {
            Neuron neuron2 = edge.neighbor;
            neuron2.update(x, this.epsNeighbor);
            if (neuron2 != s2) continue;
            edge.age = 0;
            s2.setEdgeAge(s1, 0);
            addEdge = false;
        }
        if (addEdge) {
            s1.addEdge(s2);
            s2.addEdge(s1);
            s2.update(x, this.epsNeighbor);
        }
        Iterator<Edge> iter = s1.edges.iterator();
        while (iter.hasNext()) {
            Edge edge = iter.next();
            if (edge.age <= this.edgeLifetime) continue;
            iter.remove();
            Neuron neuron3 = edge.neighbor;
            neuron3.removeEdge(s1);
            if (!neuron3.edges.isEmpty()) continue;
            this.neurons.removeIf(neuron -> neuron == neighbor);
        }
        if (this.t % this.lambda == 0) {
            void var7_12;
            Neuron q = this.neurons.getFirst();
            for (Neuron neuron4 : this.neurons) {
                if (!(neuron4.counter > q.counter)) continue;
                q = neuron4;
            }
            Neuron neuron5 = q.edges.getFirst().neighbor;
            for (Edge edge : q.edges) {
                if (!(edge.neighbor.counter > var7_12.counter)) continue;
                Neuron neuron6 = edge.neighbor;
            }
            q.counter *= this.alpha;
            var7_12.counter *= this.alpha;
            double[] dArray = new double[this.d];
            for (int i = 0; i < this.d; ++i) {
                int n = i;
                dArray[n] = dArray[n] + (q.w[i] + var7_12.w[i]) / 2.0;
            }
            Neuron r = new Neuron(dArray, q.counter);
            this.neurons.add(r);
            q.removeEdge((Neuron)var7_12);
            var7_12.removeEdge(q);
            q.addEdge(r);
            var7_12.addEdge(r);
            r.addEdge(q);
            r.addEdge((Neuron)var7_12);
        }
        for (Neuron neuron7 : this.neurons) {
            neuron7.counter *= this.beta;
        }
    }

    public Neuron[] neurons() {
        return this.neurons.toArray(new Neuron[0]);
    }

    @Override
    public double[] quantize(double[] x) {
        ((Stream)this.neurons.stream().parallel()).forEach(neuron -> neuron.distance(x));
        Neuron bmu = this.neurons.getFirst();
        for (Neuron neuron2 : this.neurons) {
            if (!(neuron2.distance < bmu.distance)) continue;
            bmu = neuron2;
        }
        return bmu.w;
    }
}

