/*
 * Decompiled with CFR 0.152.
 */
package smile.validation.metric;

import smile.validation.metric.RegressionMetric;

public class MAD
implements RegressionMetric {
    private static final long serialVersionUID = 2L;
    public static final MAD instance = new MAD();

    @Override
    public double score(double[] truth, double[] prediction) {
        return MAD.of(truth, prediction);
    }

    public static double of(double[] truth, double[] prediction) {
        if (truth.length != prediction.length) {
            throw new IllegalArgumentException(String.format("The vector sizes don't match: %d != %d.", truth.length, prediction.length));
        }
        int n = truth.length;
        double error = 0.0;
        for (int i = 0; i < n; ++i) {
            error += Math.abs(truth[i] - prediction[i]);
        }
        return error / (double)n;
    }

    public String toString() {
        return "MAD";
    }
}

