/*
 * Decompiled with CFR 0.152.
 */
package smile.timeseries;

import java.io.Serializable;
import java.util.Arrays;
import smile.math.MathEx;
import smile.math.special.Beta;
import smile.stat.Hypothesis;
import smile.tensor.Cholesky;
import smile.tensor.DenseMatrix;
import smile.tensor.SVD;
import smile.tensor.ScalarType;
import smile.tensor.Vector;
import smile.timeseries.AR;

public class ARMA
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final double[] x;
    private final double mean;
    private final int p;
    private final int q;
    private final double b;
    private final double[] ar;
    private final double[] ma;
    private double[][] ttest;
    private final double[] fittedValues;
    private final double[] residuals;
    private double RSS;
    private final double variance;
    private final int df;
    private final double R2;
    private final double adjustedR2;

    public ARMA(double[] x, double[] ar, double[] ma, double b, double[] fittedValues, double[] residuals) {
        this.x = x;
        this.p = ar.length;
        this.q = ma.length;
        this.ar = ar;
        this.ma = ma;
        this.b = b;
        this.mean = MathEx.mean((double[])x);
        this.fittedValues = fittedValues;
        this.residuals = residuals;
        int n = residuals.length;
        double ybar = 0.0;
        for (int i = x.length - n; i < x.length; ++i) {
            ybar += x[i];
        }
        ybar /= (double)n;
        double TSS = 0.0;
        this.RSS = 0.0;
        for (int i = 0; i < n; ++i) {
            this.RSS += MathEx.pow2((double)residuals[i]);
            TSS += MathEx.pow2((double)(fittedValues[i] - ybar));
        }
        this.df = n;
        this.variance = this.RSS / (double)this.df;
        this.R2 = 1.0 - this.RSS / TSS;
        this.adjustedR2 = 1.0 - (1.0 - this.R2) * (double)(n - 1) / (double)(n - this.p);
    }

    public double[] x() {
        return this.x;
    }

    public double mean() {
        return this.mean;
    }

    public int p() {
        return this.p;
    }

    public int q() {
        return this.q;
    }

    public double[][] ttest() {
        return this.ttest;
    }

    public double[] ar() {
        return this.ar;
    }

    public double[] ma() {
        return this.ma;
    }

    public double intercept() {
        return this.b;
    }

    public double[] residuals() {
        return this.residuals;
    }

    public double[] fittedValues() {
        return this.fittedValues;
    }

    public double RSS() {
        return this.RSS;
    }

    public double variance() {
        return this.variance;
    }

    public int df() {
        return this.df;
    }

    public double R2() {
        return this.R2;
    }

    public double adjustedR2() {
        return this.adjustedR2;
    }

    public static ARMA fit(double[] x, int p, int q) {
        int i;
        int j;
        if (p <= 0 || p >= x.length) {
            throw new IllegalArgumentException("Invalid order p = " + p);
        }
        if (q <= 0 || q >= x.length) {
            throw new IllegalArgumentException("Invalid order q = " + q);
        }
        int m = p + q + 20;
        int k = Math.max(p, q);
        int n = x.length - m - k;
        AR arm = AR.fit(x, m);
        double[] a = new double[x.length];
        System.arraycopy(arm.residuals(), 0, a, m, a.length - m);
        double[] y = Arrays.copyOfRange(x, m + k, x.length);
        DenseMatrix X = DenseMatrix.zeros((ScalarType)ScalarType.Float64, (int)n, (int)(p + q + 1));
        for (j = 0; j < p; ++j) {
            for (i = 0; i < n; ++i) {
                X.set(i, j, x[m + k + i - j - 1]);
            }
        }
        for (j = 0; j < q; ++j) {
            for (i = 0; i < n; ++i) {
                X.set(i, p + j, a[m + k + i - j - 1]);
            }
        }
        for (int i2 = 0; i2 < n; ++i2) {
            X.set(i2, p + q, 1.0);
        }
        SVD svd = X.copy().svd();
        Vector arma = svd.solve(y);
        double[] fittedValues = X.mv(arma).toArray(new double[0]);
        for (int j2 = 0; j2 < n; ++j2) {
            a[m + k + j2] = x[m + k + j2] - fittedValues[j2];
        }
        double[] ar = arma.slice(0, p).toArray(new double[p]);
        double[] ma = arma.slice(p, p + q).toArray(new double[q]);
        ARMA model = new ARMA(x, ar, ma, arma.get(p + q), fittedValues, Arrays.copyOfRange(a, m + k, n));
        Cholesky cholesky = X.ata().cholesky();
        DenseMatrix inv = cholesky.inverse();
        int df = model.df;
        double error = Math.sqrt(model.variance);
        double[][] ttest = new double[p + q][4];
        model.ttest = ttest;
        for (int i3 = 0; i3 < p + q; ++i3) {
            double t;
            double se;
            ttest[i3][0] = arma.get(i3);
            ttest[i3][1] = se = error * Math.sqrt(inv.get(i3, i3));
            ttest[i3][2] = t = arma.get(i3) / se;
            ttest[i3][3] = Beta.regularizedIncompleteBetaFunction((double)(0.5 * (double)df), (double)0.5, (double)((double)df / ((double)df + t * t)));
        }
        return model;
    }

    private double forecast(double[] x, double[] a, int offset) {
        int i;
        double y = this.b;
        for (i = 0; i < this.p; ++i) {
            y += this.ar[i] * x[offset - i - 1];
        }
        offset -= x.length - a.length;
        for (i = 0; i < this.q; ++i) {
            y += this.ma[i] * a[offset - i - 1];
        }
        return y;
    }

    public double forecast() {
        return this.forecast(this.x, this.residuals, this.x.length);
    }

    public double[] forecast(int l) {
        int k = Math.max(this.p, this.q);
        double[] x = new double[k + l];
        double[] a = new double[k + l];
        System.arraycopy(this.x, this.x.length - k, x, 0, k);
        System.arraycopy(this.residuals, this.residuals.length - k, a, 0, k);
        for (int i = 0; i < l; ++i) {
            x[this.p + i] = this.forecast(x, a, k + i);
        }
        return Arrays.copyOfRange(x, k, x.length);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("ARMA(%d, %d):\n", this.p, this.q));
        double[] r = (double[])this.residuals.clone();
        builder.append("\nResiduals:\n");
        builder.append("       Min          1Q      Median          3Q         Max\n");
        builder.append(String.format("%10.4f  %10.4f  %10.4f  %10.4f  %10.4f%n", MathEx.min((double[])r), MathEx.q1((double[])r), MathEx.median((double[])r), MathEx.q3((double[])r), MathEx.max((double[])r)));
        builder.append("\nCoefficients:\n");
        if (this.ttest != null) {
            builder.append("              Estimate Std. Error    t value   Pr(>|t|)\n");
            if (this.b != 0.0) {
                builder.append(String.format("Intercept   %10.4f%n", this.b));
            }
            for (int i = 0; i < this.ttest.length; ++i) {
                builder.append(String.format("%s[-%d]\t    %10.4f %10.4f %10.4f %10.4f %s%n", i < this.p ? "ar" : "ma", i + 1, this.ttest[i][0], this.ttest[i][1], this.ttest[i][2], this.ttest[i][3], Hypothesis.significance((double)this.ttest[i][3])));
            }
            builder.append("---------------------------------------------------------------------\n");
            builder.append("Significance codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1\n");
        } else {
            int i;
            if (this.b != 0.0) {
                builder.append(String.format("Intercept   %10.4f%n", this.b));
            }
            for (i = 0; i < this.p; ++i) {
                builder.append(String.format("ar[-%d]\t    %10.4f%n", i + 1, this.ar[i]));
            }
            for (i = 0; i < this.q; ++i) {
                builder.append(String.format("ma[-%d]\t    %10.4f%n", i + 1, this.ma[i]));
            }
        }
        builder.append(String.format("%nResidual  variance: %.4f on %5d degrees of freedom%n", this.variance, this.df));
        builder.append(String.format("Multiple R-squared: %.4f, Adjusted R-squared: %.4f%n", this.R2, this.adjustedR2));
        return builder.toString();
    }
}

