/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.graph.AdjacencyList;
import smile.graph.NearestNeighborGraph;
import smile.linalg.Transpose;
import smile.tensor.ARPACK;
import smile.tensor.DenseMatrix;
import smile.tensor.EVD;
import smile.tensor.LU;
import smile.tensor.Matrix;
import smile.tensor.ScalarType;
import smile.tensor.SparseMatrix;
import smile.tensor.Vector;

public class LLE {
    private static final Logger logger = LoggerFactory.getLogger(LLE.class);

    private LLE() {
    }

    public static double[][] fit(double[][] data, Options options) {
        NearestNeighborGraph nng = NearestNeighborGraph.of((double[][])data, (int)options.k);
        return LLE.fit(data, nng.largest(false), options.d);
    }

    public static double[][] fit(double[][] data, NearestNeighborGraph nng, int d) {
        int k = nng.k();
        int D = data[0].length;
        double tol = 0.0;
        if (k > D) {
            logger.info("LLE: regularization will be used since K > D.");
            tol = 0.001;
        }
        AdjacencyList graph = nng.graph(false);
        int[][] N = nng.neighbors();
        int[] index = nng.index();
        int n = index.length;
        int[] reverseIndex = new int[data.length];
        for (int i = 0; i < index.length; ++i) {
            reverseIndex[index[i]] = i;
        }
        int len = n * k;
        double[] w = new double[len];
        int[] rowIndex = new int[len];
        int[] colIndex = new int[n + 1];
        for (int i = 1; i <= n; ++i) {
            colIndex[i] = colIndex[i - 1] + k;
        }
        DenseMatrix C = DenseMatrix.zeros((ScalarType)ScalarType.Float64, (int)k, (int)k);
        Vector b = C.vector(k);
        int m = 0;
        for (int i : index) {
            int p;
            double trace = 0.0;
            double[] xi = data[i];
            for (p = 0; p < k; ++p) {
                double[] xip = data[N[i][p]];
                for (int q = 0; q < k; ++q) {
                    double[] xiq = data[N[i][q]];
                    C.set(p, q, 0.0);
                    for (int l = 0; l < D; ++l) {
                        C.add(p, q, (xi[l] - xip[l]) * (xi[l] - xiq[l]));
                    }
                }
                trace += C.get(p, p);
            }
            if (tol != 0.0) {
                trace *= tol;
                for (p = 0; p < k; ++p) {
                    C.add(p, p, trace);
                }
            }
            b.fill(1.0);
            LU lu = C.lu();
            lu.solve((DenseMatrix)b);
            double sum = b.sum();
            int[] ni = N[i];
            for (int p2 = 0; p2 < k; ++p2) {
                w[m * k + p2] = b.get(p2) / sum;
                rowIndex[m * k + p2] = reverseIndex[ni[p2]];
            }
            ++m;
        }
        SparseMatrix Wt = new SparseMatrix(n, n, w, rowIndex, colIndex);
        EVD eigen = ARPACK.syev((Matrix)new M(Wt), (ARPACK.SymmOption)ARPACK.SymmOption.SM, (int)Math.min(10 * (d + 1), n - 1));
        DenseMatrix V = eigen.Vr();
        int offset = eigen.wr().get(eigen.wr().size() - 1) < 1.0E-12 ? 2 : 1;
        double[][] coordinates = new double[n][d];
        int j = d;
        while (--j >= 0) {
            int c = V.ncol() - j - offset;
            for (int i = 0; i < n; ++i) {
                coordinates[i][j] = V.get(i, c);
            }
        }
        return coordinates;
    }

    public record Options(int k, int d) {
        public Options {
            if (k < 2) {
                throw new IllegalArgumentException("Invalid number of nearest neighbors: " + k);
            }
            if (d < 2) {
                throw new IllegalArgumentException("Invalid dimension of feature space: " + d);
            }
        }

        public Options(int k) {
            this(k, 2);
        }

        public Properties toProperties() {
            Properties props = new Properties();
            props.setProperty("smile.lle.k", Integer.toString(this.k));
            props.setProperty("smile.lle.d", Integer.toString(this.d));
            return props;
        }

        public static Options of(Properties props) {
            int k = Integer.parseInt(props.getProperty("smile.lle.k", "7"));
            int d = Integer.parseInt(props.getProperty("smile.lle.d", "2"));
            return new Options(k, d);
        }
    }

    private static class M
    implements Matrix {
        final SparseMatrix Wt;
        final Vector x;
        final Vector Wx;
        final Vector Wtx;
        final Vector WtWx;

        public M(SparseMatrix Wt) {
            this.Wt = Wt;
            this.x = Wt.vector(Wt.nrow());
            this.Wx = Wt.vector(Wt.nrow());
            this.Wtx = Wt.vector(Wt.ncol());
            this.WtWx = Wt.vector(Wt.nrow());
        }

        public int nrow() {
            return this.Wt.nrow();
        }

        public int ncol() {
            return this.nrow();
        }

        public long length() {
            return this.Wt.length();
        }

        public ScalarType scalarType() {
            return this.Wt.scalarType();
        }

        public void mv(Vector work, int inputOffset, int outputOffset) {
            Vector.copy((Vector)work, (int)inputOffset, (Vector)this.x, (int)0, (int)this.x.size());
            this.Wt.tv(this.x, this.Wx);
            this.Wt.mv(this.x, this.Wtx);
            this.Wt.mv(this.Wx, this.WtWx);
            int n = this.x.size();
            for (int i = 0; i < n; ++i) {
                work.set(outputOffset + i, this.WtWx.get(i) + this.x.get(i) - this.Wx.get(i) - this.Wtx.get(i));
            }
        }

        public void mv(Transpose trans, double alpha, Vector x, double beta, Vector y) {
            throw new UnsupportedOperationException();
        }

        public void tv(Vector work, int inputOffset, int outputOffset) {
            throw new UnsupportedOperationException();
        }

        public double get(int i, int j) {
            throw new UnsupportedOperationException();
        }

        public void set(int i, int j, double x) {
            throw new UnsupportedOperationException();
        }

        public void add(int i, int j, double x) {
            throw new UnsupportedOperationException();
        }

        public void sub(int i, int j, double x) {
            throw new UnsupportedOperationException();
        }

        public void mul(int i, int j, double x) {
            throw new UnsupportedOperationException();
        }

        public void div(int i, int j, double x) {
            throw new UnsupportedOperationException();
        }

        public Matrix scale(double alpha) {
            throw new UnsupportedOperationException();
        }

        public Matrix copy() {
            throw new UnsupportedOperationException();
        }

        public Matrix transpose() {
            throw new UnsupportedOperationException();
        }
    }
}

