/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.io.Serializable;
import java.util.LinkedList;
import smile.clustering.FastPair;
import smile.clustering.linkage.Linkage;
import smile.clustering.linkage.UPGMCLinkage;
import smile.clustering.linkage.WPGMCLinkage;
import smile.clustering.linkage.WardLinkage;
import smile.sort.IntHeapSelect;

public record HierarchicalClustering(int[][] tree, double[] height) implements Serializable
{
    private static final long serialVersionUID = 3L;

    public static HierarchicalClustering fit(Linkage linkage) {
        int i;
        int n = linkage.size();
        int[][] merge = new int[n - 1][2];
        int[] id = new int[n];
        double[] height = new double[n - 1];
        int[] points = new int[n];
        for (int i2 = 0; i2 < n; ++i2) {
            points[i2] = i2;
            id[i2] = i2;
        }
        FastPair fp = new FastPair(points, linkage);
        for (i = 0; i < n - 1; ++i) {
            height[i] = fp.getNearestPair(merge[i]);
            linkage.merge(merge[i][0], merge[i][1]);
            fp.remove(merge[i][1]);
            fp.updatePoint(merge[i][0]);
            int p = merge[i][0];
            int q = merge[i][1];
            merge[i][0] = Math.min(id[p], id[q]);
            merge[i][1] = Math.max(id[p], id[q]);
            id[p] = n + i;
        }
        if (linkage instanceof UPGMCLinkage || linkage instanceof WPGMCLinkage || linkage instanceof WardLinkage) {
            for (i = 0; i < height.length; ++i) {
                height[i] = Math.sqrt(height[i]);
            }
        }
        return new HierarchicalClustering(merge, height);
    }

    public int[] partition(int k) {
        int i;
        int n = this.tree.length + 1;
        int[] membership = new int[n];
        IntHeapSelect heap = new IntHeapSelect(k);
        for (i = 2; i <= k; ++i) {
            heap.add(this.tree[n - i][0]);
            heap.add(this.tree[n - i][1]);
        }
        for (i = 0; i < k; ++i) {
            this.bfs(membership, heap.get(i), i);
        }
        return membership;
    }

    public int[] partition(double h) {
        int k;
        for (int i = 0; i < this.height.length - 1; ++i) {
            if (!(this.height[i] > this.height[i + 1])) continue;
            throw new IllegalStateException("Non-monotonic cluster tree -- the linkage is probably not appropriate!");
        }
        int n = this.tree.length + 1;
        for (k = 2; k <= n && !(this.height[n - k] < h); ++k) {
        }
        if (k <= 2) {
            throw new IllegalArgumentException("The parameter h is too large.");
        }
        return this.partition(k - 1);
    }

    private void bfs(int[] membership, int cluster, int id) {
        int n = this.tree.length + 1;
        LinkedList<Integer> queue = new LinkedList<Integer>();
        queue.offer(cluster);
        Integer i = (Integer)queue.poll();
        while (i != null) {
            if (i < n) {
                membership[i.intValue()] = id;
            } else {
                int m1 = this.tree[i = Integer.valueOf(i - n)][0];
                if (m1 >= n) {
                    queue.offer(m1);
                } else {
                    membership[m1] = id;
                }
                int m2 = this.tree[i][1];
                if (m2 >= n) {
                    queue.offer(m2);
                } else {
                    membership[m2] = id;
                }
            }
            i = (Integer)queue.poll();
        }
    }
}

