/*
 * Decompiled with CFR 0.152.
 */
package smile.base.svm;

import java.io.Serializable;
import smile.base.svm.KernelMachine;
import smile.math.MathEx;
import smile.math.kernel.BinarySparseLinearKernel;
import smile.math.kernel.LinearKernel;
import smile.math.kernel.SparseLinearKernel;
import smile.util.SparseArray;

public class LinearKernelMachine
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final double[] w;
    private final double b;

    public LinearKernelMachine(double[] w, double b) {
        this.w = w;
        this.b = b;
    }

    public double[] weights() {
        return this.w;
    }

    public double intercept() {
        return this.b;
    }

    public static LinearKernelMachine of(KernelMachine<double[]> kernelMachine) {
        if (!(kernelMachine.kernel instanceof LinearKernel)) {
            throw new IllegalArgumentException("Not a linear kernel");
        }
        int n = ((double[][])kernelMachine.vectors).length;
        int p = ((double[][])kernelMachine.vectors)[0].length;
        double[] w = new double[p];
        for (int i = 0; i < n; ++i) {
            double alpha = kernelMachine.w[i];
            double[] x = ((double[][])kernelMachine.vectors)[i];
            for (int j = 0; j < p; ++j) {
                int n2 = j;
                w[n2] = w[n2] + alpha * x[j];
            }
        }
        return new LinearKernelMachine(w, kernelMachine.b);
    }

    public static LinearKernelMachine binary(int p, KernelMachine<int[]> kernelMachine) {
        if (!(kernelMachine.kernel instanceof BinarySparseLinearKernel)) {
            throw new IllegalArgumentException("Not a linear kernel");
        }
        double[] w = new double[p];
        double[] alpha = kernelMachine.w;
        int[][] nArray = (int[][])kernelMachine.vectors;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] x;
            int[] nArray2 = x = nArray[i];
            int n2 = nArray2.length;
            for (int j = 0; j < n2; ++j) {
                int i2;
                int n3 = i2 = nArray2[j];
                w[n3] = w[n3] + alpha[i2];
            }
        }
        return new LinearKernelMachine(w, kernelMachine.b);
    }

    public static LinearKernelMachine sparse(int p, KernelMachine<SparseArray> kernelMachine) {
        if (!(kernelMachine.kernel instanceof SparseLinearKernel)) {
            throw new IllegalArgumentException("Not a linear kernel");
        }
        double[] w = new double[p];
        double[] alpha = kernelMachine.w;
        for (SparseArray x : (SparseArray[])kernelMachine.vectors) {
            for (SparseArray.Entry e : x) {
                int n = e.index();
                w[n] = w[n] + alpha[e.index()] * e.value();
            }
        }
        return new LinearKernelMachine(w, kernelMachine.b);
    }

    public double f(double[] x) {
        return this.b + MathEx.dot((double[])this.w, (double[])x);
    }

    public double f(int[] x) {
        double f = this.b;
        for (int i : x) {
            f += this.w[i];
        }
        return f;
    }

    public double f(SparseArray x) {
        double f = this.b;
        for (SparseArray.Entry e : x) {
            f += this.w[e.index()] * e.value();
        }
        return f;
    }
}

