/*
 * Decompiled with CFR 0.152.
 */
package smile.base.svm;

import java.io.Serializable;
import smile.math.kernel.MercerKernel;

public class KernelMachine<T>
implements Serializable {
    private static final long serialVersionUID = 2L;
    final MercerKernel<T> kernel;
    final T[] vectors;
    final double[] w;
    final double b;

    public KernelMachine(MercerKernel<T> kernel, T[] vectors, double[] weight) {
        this(kernel, vectors, weight, 0.0);
    }

    public KernelMachine(MercerKernel<T> kernel, T[] vectors, double[] weight, double b) {
        this.kernel = kernel;
        this.vectors = vectors;
        this.w = weight;
        this.b = b;
    }

    public MercerKernel<T> kernel() {
        return this.kernel;
    }

    public T[] vectors() {
        return this.vectors;
    }

    public double[] weights() {
        return this.w;
    }

    public double intercept() {
        return this.b;
    }

    public double score(T x) {
        double f = this.b;
        for (int i = 0; i < this.vectors.length; ++i) {
            f += this.w[i] * this.kernel.k(x, this.vectors[i]);
        }
        return f;
    }

    public String toString() {
        return String.format("Kernel Machine (%s): %d vectors, intercept = %.4f", this.kernel, this.vectors.length, this.b);
    }
}

