/*
 * Decompiled with CFR 0.152.
 */
package smile.tensor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import smile.math.MathEx;
import smile.tensor.AbstractTensor;
import smile.tensor.ScalarType;
import smile.tensor.Vector;

class Vector64
extends Vector {
    final double[] array;
    final int offset;
    final int length;

    private Vector64() {
        this.array = null;
        this.offset = 0;
        this.length = 0;
    }

    private Vector64(MemorySegment memory, double[] array, int offset, int length, int m, int n) {
        if (offset < 0 || offset >= array.length) {
            throw new IllegalArgumentException("Invalid offset: " + offset);
        }
        if (offset + length > array.length) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        if (m != 1 && n != 1) {
            throw new IllegalArgumentException("Invalid vector dimension: " + m + " x " + n);
        }
        if (m != length && n != length) {
            throw new IllegalArgumentException("Invalid vector dimension: " + m + " x " + n);
        }
        super(memory, m, n);
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    public static Vector64 column(double[] array, int offset, int length) {
        return new Vector64(Vector64.memory(array, offset, length), array, offset, length, length, 1);
    }

    public static Vector64 row(double[] array, int offset, int length) {
        return new Vector64(Vector64.memory(array, offset, length), array, offset, length, 1, length);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.memory = Vector64.memory(this.array, this.offset, this.length);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Vector64) {
            Vector64 b = (Vector64)other;
            if (this.length == b.length) {
                for (int i = 0; i < this.length; ++i) {
                    if (!(Math.abs(this.array[this.offset + i] - b.array[b.offset + i]) > (double)MathEx.FLOAT_EPSILON)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        String suffix = this.size() > 10 ? ", ...]" : "]";
        return IntStream.range(0, this.length).limit(10L).mapToObj(i -> AbstractTensor.format(this.array[this.offset + i])).collect(Collectors.joining(", ", "[", suffix));
    }

    @Override
    public ScalarType scalarType() {
        return ScalarType.Float64;
    }

    @Override
    public Vector64 transpose() {
        return new Vector64(this.memory, this.array, this.offset, this.length, this.n, this.m);
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public double get(int i, int j) {
        assert (i == 0 || j == 0);
        return this.array[this.offset + i + j];
    }

    @Override
    public void set(int i, int j, double x) {
        assert (i == 0 || j == 0);
        this.array[this.offset + i + j] = x;
    }

    @Override
    public void add(int i, int j, double x) {
        assert (i == 0 || j == 0);
        int n = this.offset + i + j;
        this.array[n] = this.array[n] + x;
    }

    @Override
    public void sub(int i, int j, double x) {
        assert (i == 0 || j == 0);
        int n = this.offset + i + j;
        this.array[n] = this.array[n] - x;
    }

    @Override
    public void mul(int i, int j, double x) {
        assert (i == 0 || j == 0);
        int n = this.offset + i + j;
        this.array[n] = this.array[n] * x;
    }

    @Override
    public void div(int i, int j, double x) {
        assert (i == 0 || j == 0);
        int n = this.offset + i + j;
        this.array[n] = this.array[n] / x;
    }

    @Override
    public double get(int i) {
        return this.array[this.offset + i];
    }

    @Override
    public void set(int i, double x) {
        this.array[this.offset + i] = x;
    }

    @Override
    public void add(int i, double x) {
        int n = this.offset + i;
        this.array[n] = this.array[n] + x;
    }

    @Override
    public void sub(int i, double x) {
        int n = this.offset + i;
        this.array[n] = this.array[n] - x;
    }

    @Override
    public void mul(int i, double x) {
        int n = this.offset + i;
        this.array[n] = this.array[n] * x;
    }

    @Override
    public void div(int i, double x) {
        int n = this.offset + i;
        this.array[n] = this.array[n] / x;
    }

    @Override
    public Vector slice(int from, int to) {
        int length = to - from;
        long byteSize = this.scalarType().byteSize();
        MemorySegment slice = this.memory.asSlice((long)from * byteSize, (long)length * byteSize);
        int m = this.nrow() > 1 ? length : 1;
        int n = this.nrow() > 1 ? 1 : length;
        return new Vector64(slice, this.array, this.offset + from, length, m, n);
    }

    @Override
    public Vector copy(int from, int to) {
        double[] data = Arrays.copyOfRange(this.array, this.offset + from, this.offset + to);
        int length = data.length;
        return this.nrow() > 1 ? Vector64.column(data, 0, length) : Vector64.row(data, 0, length);
    }

    @Override
    public double[] toArray(double[] a) {
        if (a.length < this.length) {
            a = Arrays.copyOfRange(this.array, this.offset, this.offset + this.length);
        } else {
            System.arraycopy(this.array, this.offset, a, 0, this.length);
        }
        return a;
    }

    @Override
    public float[] toArray(float[] a) {
        if (a.length < this.length) {
            a = new float[this.length];
        }
        for (int i = 0; i < this.length; ++i) {
            a[i] = (float)this.array[this.offset + i];
        }
        return a;
    }

    @Override
    public void fill(double value) {
        Arrays.fill(this.array, this.offset, this.offset + this.length, value);
    }

    @Override
    public void fill(int from, int to, double value) {
        Arrays.fill(this.array, this.offset + from, this.offset + to, value);
    }

    @Override
    public int softmax() {
        int i;
        int k = this.length;
        int y = -1;
        double max = Double.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < k; ++i2) {
            if (!(this.array[this.offset + i2] > max)) continue;
            max = this.array[this.offset + i2];
            y = i2;
        }
        double Z = 0.0;
        for (i = 0; i < k; ++i) {
            double out;
            this.array[this.offset + i] = out = Math.exp(this.array[this.offset + i] - max);
            Z += out;
        }
        for (i = 0; i < k; ++i) {
            int n = this.offset + i;
            this.array[n] = this.array[n] / Z;
        }
        return y;
    }
}

