/*
 * Decompiled with CFR 0.152.
 */
package smile.tensor;

import java.io.Serializable;
import smile.sort.QuickSort;
import smile.tensor.DenseMatrix;
import smile.tensor.Vector;

public record EVD(Vector wr, Vector wi, DenseMatrix Vl, DenseMatrix Vr) implements Serializable
{
    public EVD(Vector w, DenseMatrix V) {
        this(w, null, V, V);
    }

    public DenseMatrix diag() {
        DenseMatrix D = this.wr.diagflat();
        if (this.wi != null) {
            int n = this.wr.size();
            for (int i = 0; i < n; ++i) {
                double wii = this.wi.get(i);
                if (wii > 0.0) {
                    D.set(i, i + 1, wii);
                    continue;
                }
                if (!(wii < 0.0)) continue;
                D.set(i, i - 1, wii);
            }
        }
        return D;
    }

    public EVD sort() {
        int n = this.wr.size();
        double[] w = new double[n];
        if (this.wi != null) {
            for (i = 0; i < n; ++i) {
                w[i] = -(this.wr.get(i) * this.wr.get(i) + this.wi.get(i) * this.wi.get(i));
            }
        } else {
            for (i = 0; i < n; ++i) {
                w[i] = -(this.wr.get(i) * this.wr.get(i));
            }
        }
        int[] index = QuickSort.sort(w);
        Vector wr2 = this.wr.zeros(n);
        for (int j = 0; j < n; ++j) {
            wr2.set(j, this.wr.get(index[j]));
        }
        Vector wi2 = null;
        if (this.wi != null) {
            wi2 = this.wi.zeros(n);
            for (int j = 0; j < n; ++j) {
                wi2.set(j, this.wi.get(index[j]));
            }
        }
        DenseMatrix Vl2 = null;
        if (this.Vl != null) {
            int m = this.Vl.m;
            Vl2 = this.Vl.zeros(m, n);
            for (int j = 0; j < n; ++j) {
                for (int i = 0; i < m; ++i) {
                    Vl2.set(i, j, this.Vl.get(i, index[j]));
                }
            }
        }
        DenseMatrix Vr2 = null;
        if (this.Vr != null) {
            int m = this.Vr.m;
            Vr2 = this.Vr.zeros(m, n);
            for (int j = 0; j < n; ++j) {
                for (int i = 0; i < m; ++i) {
                    Vr2.set(i, j, this.Vr.get(i, index[j]));
                }
            }
        }
        return new EVD(wr2, wi2, Vl2, Vr2);
    }
}

