/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import java.io.Serializable;
import java.util.Locale;
import java.util.function.ToDoubleBiFunction;
import java.util.regex.Matcher;
import java.util.stream.IntStream;
import smile.linalg.UPLO;
import smile.math.kernel.BinarySparseGaussianKernel;
import smile.math.kernel.BinarySparseHyperbolicTangentKernel;
import smile.math.kernel.BinarySparseLaplacianKernel;
import smile.math.kernel.BinarySparseLinearKernel;
import smile.math.kernel.BinarySparseMaternKernel;
import smile.math.kernel.BinarySparsePolynomialKernel;
import smile.math.kernel.BinarySparseThinPlateSplineKernel;
import smile.math.kernel.GaussianKernel;
import smile.math.kernel.HellingerKernel;
import smile.math.kernel.HyperbolicTangentKernel;
import smile.math.kernel.KernelPatterns;
import smile.math.kernel.LaplacianKernel;
import smile.math.kernel.LinearKernel;
import smile.math.kernel.MaternKernel;
import smile.math.kernel.PearsonKernel;
import smile.math.kernel.PolynomialKernel;
import smile.math.kernel.SparseGaussianKernel;
import smile.math.kernel.SparseHyperbolicTangentKernel;
import smile.math.kernel.SparseLaplacianKernel;
import smile.math.kernel.SparseLinearKernel;
import smile.math.kernel.SparseMaternKernel;
import smile.math.kernel.SparsePolynomialKernel;
import smile.math.kernel.SparseThinPlateSplineKernel;
import smile.math.kernel.ThinPlateSplineKernel;
import smile.tensor.DenseMatrix;
import smile.tensor.ScalarType;
import smile.util.SparseArray;

public interface MercerKernel<T>
extends ToDoubleBiFunction<T, T>,
Serializable {
    public double k(T var1, T var2);

    public double[] kg(T var1, T var2);

    default public double apply(T x, T y) {
        return this.k(x, y);
    }

    @Override
    default public double applyAsDouble(T x, T y) {
        return this.k(x, y);
    }

    default public DenseMatrix[] KG(T[] x) {
        int n = x.length;
        int m = this.lo().length;
        DenseMatrix[] K = new DenseMatrix[m + 1];
        for (int i = 0; i <= m; ++i) {
            K[i] = DenseMatrix.zeros(ScalarType.Float64, n, n);
            K[i].withUplo(UPLO.LOWER);
        }
        IntStream.range(0, n).parallel().forEach(j -> {
            Object xj = x[j];
            for (int i = 0; i < n; ++i) {
                double[] kg = this.kg(x[i], xj);
                for (int l = 0; l <= m; ++l) {
                    K[l].set(i, j, kg[l]);
                }
            }
        });
        return K;
    }

    default public DenseMatrix K(T[] x) {
        int n = x.length;
        DenseMatrix K = DenseMatrix.zeros(ScalarType.Float64, n, n);
        IntStream.range(0, n).parallel().forEach(j -> {
            Object xj = x[j];
            for (int i = 0; i < n; ++i) {
                K.set(i, j, this.k(x[i], xj));
            }
        });
        K.withUplo(UPLO.LOWER);
        return K;
    }

    default public DenseMatrix K(T[] x, T[] y) {
        int m = x.length;
        int n = y.length;
        DenseMatrix K = DenseMatrix.zeros(ScalarType.Float64, m, n);
        IntStream.range(0, n).parallel().forEach(j -> {
            Object yj = y[j];
            for (int i = 0; i < m; ++i) {
                K.set(i, j, this.k(x[i], yj));
            }
        });
        return K;
    }

    public MercerKernel<T> of(double[] var1);

    public double[] hyperparameters();

    public double[] lo();

    public double[] hi();

    public static MercerKernel<double[]> of(String kernel) {
        Matcher m = KernelPatterns.linear.matcher(kernel = kernel.trim().toLowerCase(Locale.ROOT));
        if (m.matches()) {
            return new LinearKernel();
        }
        m = KernelPatterns.polynomial.matcher(kernel);
        if (m.matches()) {
            int degree = Integer.parseInt(m.group(1));
            double scale = Double.parseDouble(m.group(2));
            double offset = Double.parseDouble(m.group(3));
            return new PolynomialKernel(degree, scale, offset);
        }
        m = KernelPatterns.gaussian.matcher(kernel);
        if (m.matches()) {
            double sigma = Double.parseDouble(m.group(1));
            return new GaussianKernel(sigma);
        }
        m = KernelPatterns.matern.matcher(kernel);
        if (m.matches()) {
            double sigma = Double.parseDouble(m.group(1));
            double nu = Double.parseDouble(m.group(2));
            return new MaternKernel(sigma, nu);
        }
        m = KernelPatterns.laplacian.matcher(kernel);
        if (m.matches()) {
            double scale = Double.parseDouble(m.group(1));
            return new LaplacianKernel(scale);
        }
        m = KernelPatterns.tanh.matcher(kernel);
        if (m.matches()) {
            double scale = Double.parseDouble(m.group(1));
            double offset = Double.parseDouble(m.group(2));
            return new HyperbolicTangentKernel(scale, offset);
        }
        m = KernelPatterns.thinPlateSpline.matcher(kernel);
        if (m.matches()) {
            double sigma = Double.parseDouble(m.group(1));
            return new ThinPlateSplineKernel(sigma);
        }
        m = KernelPatterns.pearson.matcher(kernel);
        if (m.matches()) {
            double sigma = Double.parseDouble(m.group(1));
            double omega = Double.parseDouble(m.group(2));
            return new PearsonKernel(sigma, omega);
        }
        m = KernelPatterns.hellinger.matcher(kernel);
        if (m.matches()) {
            return new HellingerKernel();
        }
        throw new IllegalArgumentException("Unknown kernel: " + kernel);
    }

    public static MercerKernel<SparseArray> sparse(String kernel) {
        Matcher m = KernelPatterns.linear.matcher(kernel = kernel.trim());
        if (m.matches()) {
            return new SparseLinearKernel();
        }
        m = KernelPatterns.polynomial.matcher(kernel);
        if (m.matches()) {
            int degree = Integer.parseInt(m.group(1));
            double scale = Double.parseDouble(m.group(2));
            double offset = Double.parseDouble(m.group(3));
            return new SparsePolynomialKernel(degree, scale, offset);
        }
        m = KernelPatterns.gaussian.matcher(kernel);
        if (m.matches()) {
            double sigma = Double.parseDouble(m.group(1));
            return new SparseGaussianKernel(sigma);
        }
        m = KernelPatterns.matern.matcher(kernel);
        if (m.matches()) {
            double sigma = Double.parseDouble(m.group(1));
            double nu = Double.parseDouble(m.group(2));
            return new SparseMaternKernel(sigma, nu);
        }
        m = KernelPatterns.laplacian.matcher(kernel);
        if (m.matches()) {
            double scale = Double.parseDouble(m.group(1));
            return new SparseLaplacianKernel(scale);
        }
        m = KernelPatterns.tanh.matcher(kernel);
        if (m.matches()) {
            double scale = Double.parseDouble(m.group(1));
            double offset = Double.parseDouble(m.group(2));
            return new SparseHyperbolicTangentKernel(scale, offset);
        }
        m = KernelPatterns.thinPlateSpline.matcher(kernel);
        if (m.matches()) {
            double sigma = Double.parseDouble(m.group(1));
            return new SparseThinPlateSplineKernel(sigma);
        }
        throw new IllegalArgumentException("Unknown kernel: " + kernel);
    }

    public static MercerKernel<int[]> binary(String kernel) {
        Matcher m = KernelPatterns.linear.matcher(kernel = kernel.trim());
        if (m.matches()) {
            return new BinarySparseLinearKernel();
        }
        m = KernelPatterns.polynomial.matcher(kernel);
        if (m.matches()) {
            int degree = Integer.parseInt(m.group(1));
            double scale = Double.parseDouble(m.group(2));
            double offset = Double.parseDouble(m.group(3));
            return new BinarySparsePolynomialKernel(degree, scale, offset);
        }
        m = KernelPatterns.gaussian.matcher(kernel);
        if (m.matches()) {
            double sigma = Double.parseDouble(m.group(1));
            return new BinarySparseGaussianKernel(sigma);
        }
        m = KernelPatterns.matern.matcher(kernel);
        if (m.matches()) {
            double sigma = Double.parseDouble(m.group(1));
            double nu = Double.parseDouble(m.group(2));
            return new BinarySparseMaternKernel(sigma, nu);
        }
        m = KernelPatterns.laplacian.matcher(kernel);
        if (m.matches()) {
            double scale = Double.parseDouble(m.group(1));
            return new BinarySparseLaplacianKernel(scale);
        }
        m = KernelPatterns.tanh.matcher(kernel);
        if (m.matches()) {
            double scale = Double.parseDouble(m.group(1));
            double offset = Double.parseDouble(m.group(2));
            return new BinarySparseHyperbolicTangentKernel(scale, offset);
        }
        m = KernelPatterns.thinPlateSpline.matcher(kernel);
        if (m.matches()) {
            double sigma = Double.parseDouble(m.group(1));
            return new BinarySparseThinPlateSplineKernel(sigma);
        }
        throw new IllegalArgumentException("Unknown kernel: " + kernel);
    }
}

