/*
 * Decompiled with CFR 0.152.
 */
package smile.math.kernel;

import smile.linalg.UPLO;
import smile.tensor.DenseMatrix;
import smile.util.function.Function;

public interface IsotropicKernel
extends Function {
    @Override
    default public double f(double dist) {
        return this.k(dist);
    }

    public double k(double var1);

    public double[] kg(double var1);

    @Override
    default public double apply(double dist) {
        return this.k(dist);
    }

    default public DenseMatrix K(DenseMatrix pdist) {
        if (pdist.nrow() != pdist.ncol()) {
            throw new IllegalArgumentException(String.format("pdist is not square: %d x %d", pdist.nrow(), pdist.ncol()));
        }
        int n = pdist.nrow();
        DenseMatrix K = pdist.zeros(n, n);
        for (int j = 0; j < n; ++j) {
            K.set(j, j, this.k(pdist.get(j, j)));
            for (int i = j + 1; i < n; ++i) {
                double k = this.k(pdist.get(i, j));
                K.set(i, j, k);
                K.set(j, i, k);
            }
        }
        K.withUplo(UPLO.LOWER);
        return K;
    }

    default public DenseMatrix[] KG(DenseMatrix pdist) {
        if (pdist.nrow() != pdist.ncol()) {
            throw new IllegalArgumentException(String.format("pdist is not square: %d x %d", pdist.nrow(), pdist.ncol()));
        }
        int n = pdist.nrow();
        int m = this.kg(pdist.get(0, 0)).length;
        DenseMatrix[] K = new DenseMatrix[m];
        for (int i = 0; i < m; ++i) {
            K[i] = pdist.zeros(n, n);
            K[i].withUplo(UPLO.LOWER);
        }
        for (int j = 0; j < n; ++j) {
            double[] kg = this.kg(pdist.get(j, j));
            for (int l = 0; l < m; ++l) {
                K[l].set(j, j, kg[l]);
            }
            for (int i = j + 1; i < n; ++i) {
                kg = this.kg(pdist.get(i, j));
                for (int l = 0; l < m; ++l) {
                    K[l].set(i, j, kg[l]);
                    K[l].set(j, i, kg[l]);
                }
            }
        }
        return K;
    }
}

