/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.BitSet;
import java.util.stream.IntStream;
import smile.data.measure.NumericalMeasure;
import smile.data.type.DataTypes;
import smile.data.type.StructField;
import smile.data.vector.NullablePrimitiveVector;
import smile.util.Index;

public class NullableBooleanVector
extends NullablePrimitiveVector {
    private final BitSet vector;
    private final int size;

    public NullableBooleanVector(String name, boolean[] vector, BitSet nullMask) {
        this(new StructField(name, DataTypes.NullableBooleanType), vector, nullMask);
    }

    public NullableBooleanVector(StructField field, boolean[] vector, BitSet nullMask) {
        this(field, vector.length, NullableBooleanVector.bitSet(vector), nullMask);
    }

    public NullableBooleanVector(String name, int size, BitSet bits, BitSet nullMask) {
        this(new StructField(name, DataTypes.NullableBooleanType), size, bits, nullMask);
    }

    public NullableBooleanVector(StructField field, int size, BitSet bits, BitSet nullMask) {
        if (field.dtype() != DataTypes.NullableBooleanType) {
            throw new IllegalArgumentException("Invalid data type: " + String.valueOf(field));
        }
        if (field.measure() instanceof NumericalMeasure) {
            throw new IllegalArgumentException("Invalid measure: " + String.valueOf(field.measure()));
        }
        super(field, nullMask);
        this.size = size;
        this.vector = bits;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public NullableBooleanVector withName(String name) {
        return new NullableBooleanVector(this.field.withName(name), this.size, this.vector, this.nullMask);
    }

    @Override
    public IntStream intStream() {
        return this.index().map(i -> this.nullMask.get(i) ? Integer.MIN_VALUE : (this.vector.get(i) ? 1 : 0));
    }

    @Override
    public void set(int i, Object value) {
        if (value == null) {
            this.nullMask.set(i);
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            this.vector.set(i, bool);
        } else {
            throw new IllegalArgumentException("Invalid value type: " + String.valueOf(value.getClass()));
        }
    }

    @Override
    public NullableBooleanVector get(Index index) {
        int n = index.size();
        BitSet data = new BitSet(n);
        BitSet mask = new BitSet(n);
        for (int i = 0; i < n; ++i) {
            int idx = index.apply(i);
            data.set(i, this.vector.get(idx));
            mask.set(i, this.nullMask.get(idx));
        }
        return new NullableBooleanVector(this.field, n, data, mask);
    }

    @Override
    public Boolean get(int i) {
        return this.nullMask.get(i) ? null : Boolean.valueOf(this.vector.get(i));
    }

    @Override
    public boolean getBoolean(int i) {
        return this.vector.get(i);
    }

    @Override
    public char getChar(int i) {
        return this.vector.get(i) ? (char)'T' : 'F';
    }

    @Override
    public byte getByte(int i) {
        return this.vector.get(i) ? (byte)1 : 0;
    }

    @Override
    public short getShort(int i) {
        return this.vector.get(i) ? (short)1 : 0;
    }

    @Override
    public int getInt(int i) {
        return this.vector.get(i) ? 1 : 0;
    }

    @Override
    public long getLong(int i) {
        return this.vector.get(i) ? 1L : 0L;
    }

    @Override
    public float getFloat(int i) {
        return this.vector.get(i) ? 1.0f : 0.0f;
    }

    @Override
    public double getDouble(int i) {
        return this.vector.get(i) ? 1.0 : 0.0;
    }
}

