/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.graph.dot;

import com.github.ferstl.depgraph.graph.Edge;
import com.github.ferstl.depgraph.graph.GraphFormatter;
import com.github.ferstl.depgraph.graph.Node;
import com.github.ferstl.depgraph.graph.dot.DotAttributeBuilder;
import com.github.ferstl.depgraph.graph.dot.DotEscaper;
import java.util.Collection;

public class DotGraphFormatter
implements GraphFormatter {
    private final DotAttributeBuilder graphAttributeBuilder;
    private final DotAttributeBuilder nodeAttributeBuilder;
    private final DotAttributeBuilder edgeAttributeBuilder;

    public DotGraphFormatter() {
        this.graphAttributeBuilder = new DotAttributeBuilder();
        this.nodeAttributeBuilder = new DotAttributeBuilder().shape("box").fontName("Helvetica");
        this.edgeAttributeBuilder = new DotAttributeBuilder().fontName("Helvetica").fontSize(10);
    }

    public DotGraphFormatter(DotAttributeBuilder graphAttributeBuilder, DotAttributeBuilder nodeAttributeBuilder, DotAttributeBuilder edgeAttributeBuilder) {
        this.graphAttributeBuilder = graphAttributeBuilder;
        this.nodeAttributeBuilder = nodeAttributeBuilder;
        this.edgeAttributeBuilder = edgeAttributeBuilder;
    }

    @Override
    public String format(String graphName, Collection<Node<?>> nodes, Collection<Edge> edges) {
        StringBuilder sb = new StringBuilder("digraph ").append(DotEscaper.escape(graphName)).append(" {");
        this.appendAttributes("graph", this.graphAttributeBuilder, sb);
        this.appendAttributes("node", this.nodeAttributeBuilder, sb);
        this.appendAttributes("edge", this.edgeAttributeBuilder, sb);
        sb.append("\n\n  // Node Definitions:");
        for (Node<?> node : nodes) {
            String nodeId = node.getNodeId();
            String nodeName = node.getNodeName();
            sb.append("\n  ").append(DotEscaper.escape(nodeId)).append(nodeName);
        }
        sb.append("\n\n  // Edge Definitions:");
        for (Edge edge : edges) {
            String edgeDefinition = DotEscaper.escape(edge.getFromNodeId()) + " -> " + DotEscaper.escape(edge.getToNodeId()) + edge.getName();
            sb.append("\n  ").append(edgeDefinition);
        }
        return sb.append("\n}").toString();
    }

    private void appendAttributes(String tagName, DotAttributeBuilder attributeBuilder, StringBuilder sb) {
        if (!attributeBuilder.isEmpty()) {
            sb.append("\n  ").append(tagName).append(" ").append(attributeBuilder);
        }
    }
}

