/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency;

import com.github.ferstl.depgraph.dependency.DependencyGraphException;
import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.GraphBuildingVisitor;
import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.github.ferstl.depgraph.graph.GraphBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.OrArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.shared.artifact.filter.StrictPatternIncludesArtifactFilter;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.DependencyVisitor;

public final class MavenGraphAdapter {
    private final ProjectDependenciesResolver dependenciesResolver;
    private final ArtifactFilter transitiveIncludeExcludeFilter;
    private final ArtifactFilter targetFilter;
    private final Set<NodeResolution> includedResolutions;

    public MavenGraphAdapter(ProjectDependenciesResolver dependenciesResolver, ArtifactFilter transitiveIncludeExcludeFilter, ArtifactFilter targetFilter, Set<NodeResolution> includedResolutions) {
        this.dependenciesResolver = dependenciesResolver;
        this.transitiveIncludeExcludeFilter = transitiveIncludeExcludeFilter;
        this.targetFilter = targetFilter;
        this.includedResolutions = includedResolutions;
    }

    public void buildDependencyGraph(MavenProject project, ArtifactFilter globalFilter, GraphBuilder<DependencyNode> graphBuilder) {
        DependencyResolutionResult result;
        DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest();
        request.setMavenProject(project);
        request.setRepositorySession(MavenGraphAdapter.getVerboseRepositorySession(project));
        request.setResolutionFilter((node, parents) -> false);
        try {
            result = this.dependenciesResolver.resolve((DependencyResolutionRequest)request);
        }
        catch (DependencyResolutionException e) {
            throw new DependencyGraphException(e);
        }
        org.eclipse.aether.graph.DependencyNode root = result.getDependencyGraph();
        ArtifactFilter transitiveDependencyFilter = this.createTransitiveDependencyFilter(project);
        GraphBuildingVisitor visitor = new GraphBuildingVisitor(graphBuilder, globalFilter, transitiveDependencyFilter, this.targetFilter, this.includedResolutions);
        root.accept((DependencyVisitor)visitor);
    }

    private static RepositorySystemSession getVerboseRepositorySession(MavenProject project) {
        RepositorySystemSession repositorySession = project.getProjectBuildingRequest().getRepositorySession();
        DefaultRepositorySystemSession verboseRepositorySession = new DefaultRepositorySystemSession(repositorySession);
        verboseRepositorySession.setConfigProperty("aether.conflictResolver.verbose", (Object)"true");
        verboseRepositorySession.setReadOnly();
        repositorySession = verboseRepositorySession;
        return repositorySession;
    }

    private ArtifactFilter createTransitiveDependencyFilter(MavenProject project) {
        ArrayList<String> dependencyKeys = new ArrayList<String>(project.getDependencies().size());
        for (Dependency dependency : project.getDependencies()) {
            dependencyKeys.add(dependency.getManagementKey());
        }
        OrArtifactFilter artifactFilter = new OrArtifactFilter();
        artifactFilter.add(this.transitiveIncludeExcludeFilter);
        artifactFilter.add((ArtifactFilter)new StrictPatternIncludesArtifactFilter(dependencyKeys));
        artifactFilter.add((ArtifactFilter)new StrictPatternIncludesArtifactFilter(Collections.singletonList(project.getArtifact().toString())));
        return artifactFilter;
    }
}

