/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutionException;
import com.github.eirslett.maven.plugins.frontend.lib.TaskRunnerException;
import com.github.eirslett.maven.plugins.frontend.lib.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NodeTaskExecutor {
    private static final String DS = "//";
    private static final String AT = "@";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String taskName;
    private final String taskLocation;
    private final List<String> additionalArguments;
    private final NodeExecutorConfig config;

    public NodeTaskExecutor(NodeExecutorConfig config, String taskLocation) {
        this(config, taskLocation, Collections.emptyList());
    }

    public NodeTaskExecutor(NodeExecutorConfig config, String taskName, String taskLocation) {
        this(config, taskName, taskLocation, Collections.emptyList());
    }

    public NodeTaskExecutor(NodeExecutorConfig config, String taskLocation, List<String> additionalArguments) {
        this(config, NodeTaskExecutor.getTaskNameFromLocation(taskLocation), taskLocation, additionalArguments);
    }

    public NodeTaskExecutor(NodeExecutorConfig config, String taskName, String taskLocation, List<String> additionalArguments) {
        this.config = config;
        this.taskName = taskName;
        this.taskLocation = taskLocation;
        this.additionalArguments = additionalArguments;
    }

    private static String getTaskNameFromLocation(String taskLocation) {
        return taskLocation.replaceAll("^.*/([^/]+)(?:\\.js)?$", "$1");
    }

    public final void execute(String args) throws TaskRunnerException {
        String absoluteTaskLocation = this.getAbsoluteTaskLocation();
        List<String> arguments = this.getArguments(args);
        this.logger.info("Running " + NodeTaskExecutor.taskToString(this.taskName, arguments) + " in " + this.config.getWorkingDirectory());
        try {
            int result = new NodeExecutor(this.config, Utils.prepend(absoluteTaskLocation, arguments)).executeAndRedirectOutput(this.logger);
            if (result != 0) {
                throw new TaskRunnerException(NodeTaskExecutor.taskToString(this.taskName, arguments) + " failed. (error code " + result + ")");
            }
        }
        catch (ProcessExecutionException e) {
            throw new TaskRunnerException(NodeTaskExecutor.taskToString(this.taskName, arguments) + " failed.", e);
        }
    }

    private String getAbsoluteTaskLocation() {
        String location = Utils.normalize(this.taskLocation);
        if (Utils.isRelative(this.taskLocation)) {
            location = new File(this.config.getWorkingDirectory(), location).getAbsolutePath();
        }
        return location;
    }

    private List<String> getArguments(String args) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (args != null && !args.equals("null") && !args.isEmpty()) {
            arguments.addAll(Arrays.asList(args.split("\\s+")));
        }
        for (String argument : this.additionalArguments) {
            if (arguments.contains(argument)) continue;
            arguments.add(argument);
        }
        return arguments;
    }

    private static String taskToString(String taskName, List<String> arguments) {
        ArrayList<String> clonedArguments = new ArrayList<String>(arguments);
        for (int i = 0; i < clonedArguments.size(); ++i) {
            String s = (String)clonedArguments.get(i);
            boolean maskMavenProxyPassword = s.contains("proxy=");
            if (!maskMavenProxyPassword) continue;
            String bestEffortMaskedPassword = NodeTaskExecutor.maskPassword(s);
            clonedArguments.set(i, bestEffortMaskedPassword);
        }
        return "'" + taskName + " " + Utils.implode(" ", clonedArguments) + "'";
    }

    private static String maskPassword(String proxyString) {
        String retVal = proxyString;
        if (proxyString != null && !"".equals(proxyString.trim())) {
            boolean hasSchemeDefined = proxyString.contains("http:") || proxyString.contains("https:");
            boolean hasProtocolDefined = proxyString.contains(DS);
            boolean hasAtCharacterDefined = proxyString.contains(AT);
            if (hasSchemeDefined && hasProtocolDefined && hasAtCharacterDefined) {
                String userInfo;
                String[] userParts;
                int lastAtCharIndex;
                boolean hasPossibleURIUserInfo;
                int firstDoubleSlashIndex = proxyString.indexOf(DS);
                boolean bl = hasPossibleURIUserInfo = firstDoubleSlashIndex < (lastAtCharIndex = proxyString.lastIndexOf(AT));
                if (hasPossibleURIUserInfo && (userParts = (userInfo = proxyString.substring(firstDoubleSlashIndex + DS.length(), lastAtCharIndex)).split(":")).length > 0) {
                    int startOfUserNameIndex = firstDoubleSlashIndex + DS.length();
                    int firstColonInUsernameOrEndOfUserNameIndex = startOfUserNameIndex + userParts[0].length();
                    String leftPart = proxyString.substring(0, firstColonInUsernameOrEndOfUserNameIndex);
                    String rightPart = proxyString.substring(lastAtCharIndex);
                    retVal = leftPart + ":***" + rightPart;
                }
            }
        }
        return retVal;
    }
}

