/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.converters;

import com.github.dozermapper.core.converters.DateFormatContainer;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.beanutils.Converter;

public class StringConverter
implements Converter {
    private DateFormatContainer dateFormatContainer;

    public StringConverter(DateFormatContainer dateFormatContainer) {
        this.dateFormatContainer = dateFormatContainer;
    }

    public Object convert(Class destClass, Object srcObj) {
        Class<?> srcClass = srcObj.getClass();
        if (this.hasDateFormat()) {
            if (Date.class.isAssignableFrom(srcClass)) {
                return this.dateFormatContainer.getDateFormat().format((Date)srcObj);
            }
            if (Calendar.class.isAssignableFrom(srcClass)) {
                return this.dateFormatContainer.getDateFormat().format(((Calendar)srcObj).getTime());
            }
            if (TemporalAccessor.class.isAssignableFrom(srcClass)) {
                return this.dateFormatContainer.getDateTimeFormatter().format((TemporalAccessor)srcObj);
            }
            return srcObj.toString();
        }
        return srcObj.toString();
    }

    private boolean hasDateFormat() {
        return this.dateFormatContainer != null && this.dateFormatContainer.isPresent();
    }
}

