/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core;

import com.github.dozermapper.core.MapIdField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MappedFieldsTracker {
    private static final int NO_TX_ID = -1;
    private final AtomicInteger txId = new AtomicInteger(-1);
    private final Map<Object, Map<Integer, MapIdField>> mappedFields = new IdentityHashMap<Object, Map<Integer, MapIdField>>();
    private SortedMap<Integer, UndoLog> pendingTransactions = new TreeMap<Integer, UndoLog>();

    public Integer startTransaction() {
        int curTxId = this.txId.incrementAndGet();
        this.pendingTransactions.put(curTxId, new UndoLog());
        return curTxId;
    }

    public void commitTransaction(Integer txId) {
        UndoLog undoLog = (UndoLog)this.pendingTransactions.get(txId);
        if (undoLog == null) {
            throw new IllegalStateException("No transaction with ID " + txId);
        }
        if (this.pendingTransactions.firstKey().equals(txId)) {
            this.pendingTransactions.clear();
        }
    }

    public void rollbackTransaction(Integer txId) {
        UndoLog undoLog = (UndoLog)this.pendingTransactions.get(txId);
        if (undoLog == null) {
            throw new IllegalStateException("No transaction with ID " + txId);
        }
        SortedMap<Integer, UndoLog> undoLogs = this.pendingTransactions.tailMap(txId);
        Iterator<UndoLog> undoLogIterator = undoLogs.values().iterator();
        while (undoLogIterator.hasNext()) {
            UndoLog curUndoLog = undoLogIterator.next();
            curUndoLog.revert();
            undoLogIterator.remove();
        }
    }

    public boolean hasTransaction() {
        return this.pendingTransactions.size() > 0;
    }

    public void put(Object src, Object dest, String mapId) {
        MapIdField destMapIdField;
        int destId = System.identityHashCode(dest);
        Map<Integer, MapIdField> mappedTo = this.mappedFields.get(src);
        if (mappedTo == null) {
            mappedTo = new HashMap<Integer, MapIdField>();
            this.mappedFields.put(src, mappedTo);
        }
        if ((destMapIdField = mappedTo.get(destId)) == null) {
            destMapIdField = new MapIdField();
            mappedTo.put(destId, destMapIdField);
        }
        if (!destMapIdField.containsMapId(mapId)) {
            destMapIdField.put(mapId, dest);
            if (this.hasTransaction()) {
                UndoLog undoLog = (UndoLog)this.pendingTransactions.get(this.txId.get());
                undoLog.track(destMapIdField, mapId);
            }
        }
    }

    public void put(Object src, Object dest) {
        this.put(src, dest, null);
    }

    public Object getMappedValue(Object src, Class<?> destType, String mapId) {
        Map<Integer, MapIdField> alreadyMappedFields = this.mappedFields.get(src);
        if (alreadyMappedFields != null) {
            for (MapIdField alreadyMappedField : alreadyMappedFields.values()) {
                Object mappedValue = alreadyMappedField.get(mapId);
                if (mappedValue == null || !destType.isAssignableFrom(mappedValue.getClass())) continue;
                return mappedValue;
            }
        }
        return null;
    }

    public Object getMappedValue(Object src, Class<?> destType) {
        return this.getMappedValue(src, destType, null);
    }

    private static class UndoLog {
        private List<UndoLogEntry> ops = new ArrayList<UndoLogEntry>();

        private UndoLog() {
        }

        void track(MapIdField destMapIdField, String mapId) {
            this.ops.add(new UndoLogEntry(destMapIdField, mapId));
        }

        void revert() {
            for (UndoLogEntry op : this.ops) {
                op.revert();
            }
        }
    }

    private static class UndoLogEntry {
        private final MapIdField destMapIdField;
        private final String mapId;

        UndoLogEntry(MapIdField destMapIdField, String mapId) {
            this.destMapIdField = destMapIdField;
            this.mapId = mapId;
        }

        void revert() {
            this.destMapIdField.remove(this.mapId);
        }
    }
}

