/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.classmap;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.ClassMapKeyFactory;
import org.dozer.util.MappingUtils;

public class ClassMappings {
    private ConcurrentMap<String, ClassMap> classMappings = new ConcurrentHashMap<String, ClassMap>();
    private ClassMapKeyFactory keyFactory = new ClassMapKeyFactory();

    public void addDefault(Class<?> srcClass, Class<?> destClass, ClassMap classMap) {
        this.classMappings.put(this.keyFactory.createKey(srcClass, destClass), classMap);
    }

    public void add(Class<?> srcClass, Class<?> destClass, ClassMap classMap) {
        ClassMap result = this.classMappings.put(this.keyFactory.createKey(srcClass, destClass), classMap);
        this.failOnDuplicate(result, classMap);
    }

    public void add(Class<?> srcClass, Class<?> destClass, String mapId, ClassMap classMap) {
        ClassMap result = this.classMappings.put(this.keyFactory.createKey(srcClass, destClass, mapId), classMap);
        this.failOnDuplicate(result, classMap);
    }

    public void addAll(ClassMappings additionalClassMappings) {
        Map<String, ClassMap> newMappings = additionalClassMappings.getAll();
        for (Map.Entry<String, ClassMap> entry : newMappings.entrySet()) {
            ClassMap result = this.classMappings.put(entry.getKey(), entry.getValue());
            this.failOnDuplicate(result, entry.getValue());
        }
    }

    public void failOnDuplicate(Object result, ClassMap classMap) {
        if (result != null && !classMap.getSrcClassName().equals(classMap.getDestClassName())) {
            throw new IllegalArgumentException("Duplicate Class Mapping Found. Source: " + classMap.getSrcClassName() + " Destination: " + classMap.getDestClassName() + " map-id: " + classMap.getMapId());
        }
    }

    public Map<String, ClassMap> getAll() {
        return new HashMap<String, ClassMap>(this.classMappings);
    }

    public long size() {
        return this.classMappings.size();
    }

    public ClassMap find(Class<?> srcClass, Class<?> destClass) {
        return (ClassMap)this.classMappings.get(this.keyFactory.createKey(srcClass, destClass));
    }

    public boolean contains(Class<?> srcClass, Class<?> destClass, String mapId) {
        String key = this.keyFactory.createKey(srcClass, destClass, mapId);
        return this.classMappings.containsKey(key);
    }

    public ClassMap find(Class<?> srcClass, Class<?> destClass, String mapId) {
        ClassMap previous;
        String key = this.keyFactory.createKey(srcClass, destClass, mapId);
        ClassMap mapping = (ClassMap)this.classMappings.get(key);
        if (mapping == null && (mapping = this.findInterfaceMapping(destClass, srcClass, mapId)) != null && (previous = this.classMappings.putIfAbsent(this.keyFactory.createKey(srcClass, destClass, mapId), mapping)) != null) {
            mapping = previous;
        }
        if (!MappingUtils.isBlankOrNull(mapId) && mapping == null) {
            for (Map.Entry entry : this.classMappings.entrySet()) {
                ClassMap classMap = (ClassMap)entry.getValue();
                if (StringUtils.equals((CharSequence)classMap.getMapId(), (CharSequence)mapId) && classMap.getSrcClassToMap().isAssignableFrom(srcClass) && classMap.getDestClassToMap().isAssignableFrom(destClass)) {
                    return classMap;
                }
                if (!StringUtils.equals((CharSequence)classMap.getMapId(), (CharSequence)mapId) || !srcClass.equals(destClass)) continue;
                return classMap;
            }
            MappingUtils.throwMappingException("Class mapping not found by map-id: " + key);
        }
        return mapping;
    }

    private ClassMap findInterfaceMapping(Class<?> destClass, Class<?> srcClass, String mapId) {
        Object[] keys;
        for (Object key : keys = this.classMappings.keySet().toArray()) {
            ClassMap map = (ClassMap)this.classMappings.get(key);
            Class<?> mappingDestClass = map.getDestClassToMap();
            Class<?> mappingSrcClass = map.getSrcClassToMap();
            if (mapId == null && map.getMapId() != null || mapId != null && !mapId.equals(map.getMapId())) continue;
            if (this.isInterfaceImplementation(srcClass, mappingSrcClass)) {
                if (this.isInterfaceImplementation(destClass, mappingDestClass)) {
                    return map;
                }
                if (destClass.equals(mappingDestClass)) {
                    return map;
                }
            }
            if ((!destClass.isAssignableFrom(mappingDestClass) || !ClassMappings.isAbstract(destClass)) && !this.isInterfaceImplementation(destClass, mappingDestClass) || !MappingUtils.getRealClass(srcClass).equals(mappingSrcClass)) continue;
            return map;
        }
        return null;
    }

    private boolean isInterfaceImplementation(Class<?> type, Class<?> mappingType) {
        return mappingType.isInterface() && mappingType.isAssignableFrom(type);
    }

    private static boolean isAbstract(Class<?> destClass) {
        return Modifier.isAbstract(destClass.getModifiers());
    }
}

