
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.protxml.jaxb.standard;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Element;


/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;any processContents='lax' minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="analysis" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="time" use="required" type="{http://www.w3.org/2001/XMLSchema}dateTime" />
 *       &lt;attribute name="version" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "any"
})
public class ProgramDetails {

  @XmlAnyElement(lax = true)
  protected Object any;
  @XmlAttribute(name = "analysis", required = true)
  protected String analysis;
  @XmlAttribute(name = "time", required = true)
  @XmlSchemaType(name = "dateTime")
  protected XMLGregorianCalendar time;
  @XmlAttribute(name = "version")
  protected String version;

  /**
   * Gets the value of the any property.
   *
   * @return possible object is {@link Element } {@link Object }
   */
  public Object getAny() {
    return any;
  }

  /**
   * Sets the value of the any property.
   *
   * @param value allowed object is {@link Element } {@link Object }
   */
  public void setAny(Object value) {
    this.any = value;
  }

  /**
   * Gets the value of the analysis property.
   *
   * @return possible object is {@link String }
   */
  public String getAnalysis() {
    return analysis;
  }

  /**
   * Sets the value of the analysis property.
   *
   * @param value allowed object is {@link String }
   */
  public void setAnalysis(String value) {
    this.analysis = value;
  }

  /**
   * Gets the value of the time property.
   *
   * @return possible object is {@link XMLGregorianCalendar }
   */
  public XMLGregorianCalendar getTime() {
    return time;
  }

  /**
   * Sets the value of the time property.
   *
   * @param value allowed object is {@link XMLGregorianCalendar }
   */
  public void setTime(XMLGregorianCalendar value) {
    this.time = value;
  }

  /**
   * Gets the value of the version property.
   *
   * @return possible object is {@link String }
   */
  public String getVersion() {
    return version;
  }

  /**
   * Sets the value of the version property.
   *
   * @param value allowed object is {@link String }
   */
  public void setVersion(String value) {
    this.version = value;
  }

}
