
/*
 * Copyright (c) 2017 Dmitry Avtonomov
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package umich.ms.fileio.filetypes.pepxml.jaxb.standard;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.w3c.dom.Element;


/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;any processContents='lax' maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="analysis" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       &lt;attribute name="id" type="{http://regis-web.systemsbiology.net/pepXML}positiveInt" default="1" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "any"
})
public class AnalysisResult {

  @XmlAnyElement(lax = true)
  protected List<Object> any;
  @XmlAttribute(name = "analysis", required = true)
  protected String analysis;
  @XmlAttribute(name = "id")
  protected Long id;

  /**
   * Gets the value of the any property.
   *
   * <p>
   * This accessor method returns a reference to the live list, not a snapshot. Therefore any
   * modification you make to the returned list will be present inside the JAXB object. This is why
   * there is not a <CODE>set</CODE> method for the any property.
   *
   * <p>
   * For example, to add a new item, do as follows:
   * <pre>
   *    getAny().add(newItem);
   * </pre>
   *
   *
   * <p>
   * Objects of the following type(s) are allowed in the list {@link Object } {@link Element }
   */
  public List<Object> getAny() {
    if (any == null) {
      any = new ArrayList<Object>(1);
    }
    return this.any;
  }

  /**
   * Gets the value of the analysis property.
   *
   * @return possible object is {@link String }
   */
  public String getAnalysis() {
    return analysis;
  }

  /**
   * Sets the value of the analysis property.
   *
   * @param value allowed object is {@link String }
   */
  public void setAnalysis(String value) {
    this.analysis = value;
  }

  /**
   * Gets the value of the id property.
   *
   * @return possible object is {@link Long }
   */
  public long getId() {
    if (id == null) {
      return 1L;
    } else {
      return id;
    }
  }

  /**
   * Sets the value of the id property.
   *
   * @param value allowed object is {@link Long }
   */
  public void setId(Long value) {
    this.id = value;
  }

}
