/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.util.file;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Paths;

public abstract class AbstractFile
implements Closeable {
    protected static final int BUF_SIZE = 8192;
    protected String path = "";
    private BufferedInputStream bis;
    private RandomAccessFile raf;

    public AbstractFile(String path) {
        this.path = Paths.get(path, new String[0]).toAbsolutePath().normalize().toString();
    }

    public synchronized BufferedInputStream getBufferedInputStream() throws FileNotFoundException {
        if (this.bis != null) {
            throw new IllegalStateException("getBufferedInputStream() called while previous BufferedInputStream has not been closed.");
        }
        this.bis = new BufferedInputStream(new FileInputStream(this.path));
        return this.bis;
    }

    public synchronized RandomAccessFile getRandomAccessFile() throws IOException {
        if (this.raf != null) {
            return this.raf;
        }
        this.raf = new RandomAccessFile(this.path, "r");
        return this.raf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AbstractFile abstractFile = this;
        synchronized (abstractFile) {
            try {
                if (this.raf != null) {
                    this.raf.close();
                    this.raf = null;
                }
                if (this.bis != null) {
                    this.bis.close();
                    this.bis = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unrecoverable situation - couldn't close the file", e);
            }
        }
    }

    public String getPath() {
        return this.path;
    }
}

