/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.agilent.cef.example;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import umich.ms.fileio.filetypes.agilent.cef.example.IonId;

public class AgilentMSPeak
implements Comparable<AgilentMSPeak> {
    public static final int CHARGE_UNKNOWN = Integer.MIN_VALUE;
    public static String GRP_MOL_IDENTITY = "grpId";
    public static String GRP_M_COUNT = "grpMcnt";
    public static String GRP_Z_SIGN = "grpZsgn";
    public static String GRP_Z_COUNT = "grpZcnt";
    public static String GRP_Z_CARRIER = "grpZcrr";
    public static String GRP_ADDUCT = "grpAdd";
    public static String GRP_ISOTOPE_NUM = "grpIsoN";
    public static Pattern RE_PEAK_DESCRIPTION = Pattern.compile(String.format("(?<%1$s>(?<%2$s>\\d*)M(?<%3$s>\\+|-)(?<%4$s>\\d*)(?<%5$s>\\w+)(?:\\+(?<%6$s>\\[[\\w\\+\\-]+?\\]))?)(?:\\+(?<%7$s>\\d*))?", GRP_MOL_IDENTITY, GRP_M_COUNT, GRP_Z_SIGN, GRP_Z_COUNT, GRP_Z_CARRIER, GRP_ADDUCT, GRP_ISOTOPE_NUM));
    protected double rt;
    protected double mz;
    protected double abMax;
    protected double abTot;
    protected int z = Integer.MIN_VALUE;
    protected String ionDescription = "";
    IonId ionId = null;

    public IonId getIonId() {
        return this.ionId;
    }

    public void setIonId(IonId ionId) {
        this.ionId = ionId;
    }

    public double getRt() {
        return this.rt;
    }

    public void setRt(double rt) {
        this.rt = rt;
    }

    public double getMz() {
        return this.mz;
    }

    public void setMz(double mz) {
        this.mz = mz;
    }

    public double getAbMax() {
        return this.abMax;
    }

    public void setAbMax(double abMax) {
        this.abMax = abMax;
    }

    public double getAbTot() {
        return this.abTot;
    }

    public void setAbTot(double abTot) {
        this.abTot = abTot;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public String getIonDescription() {
        return this.ionDescription;
    }

    public void setIonDescription(String ionDescription) {
        this.ionDescription = ionDescription;
    }

    public IonId parseIonSignature() {
        Matcher m = RE_PEAK_DESCRIPTION.matcher(this.ionDescription);
        if (m.find()) {
            IonId id = new IonId();
            String g = m.group(GRP_MOL_IDENTITY);
            id.setMolId(g);
            g = m.group(GRP_M_COUNT);
            if (g != null && !g.isEmpty()) {
                id.setmCount(Integer.parseInt(g));
            }
            if ((g = m.group(GRP_ADDUCT)) != null) {
                id.setAdduct(g);
            }
            if ((g = m.group(GRP_ISOTOPE_NUM)) != null) {
                int isoNum = g.isEmpty() ? 0 : Integer.parseInt(g);
                id.setIsotopeNumber(isoNum);
            }
            int z = (g = m.group(GRP_Z_COUNT)).isEmpty() ? 1 : Integer.parseInt(g);
            g = m.group(GRP_Z_SIGN);
            int zSgn = "+".equals(g) ? 1 : -1;
            id.setZ(z *= zSgn);
            g = m.group(GRP_Z_CARRIER);
            id.setzCarrier(g);
            return id;
        }
        return null;
    }

    @Override
    public int compareTo(AgilentMSPeak o) {
        return Double.compare(this.mz, o.mz);
    }
}

