/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande.actions;

import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.MailAction;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeListUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.actions.SaveDemandeFromListAction;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import org.nuiton.i18n.I18n;

public class ArchiveFromListAction
extends SaveDemandeFromListAction {
    protected List<DemandeUIModel> demandsToArchive;

    public ArchiveFromListAction(DemandeListUIHandler handler) {
        super(handler);
        this.setActionDescription(I18n.t((String)"faxtomail.action.archive.tip", (Object[])new Object[0]));
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        this.demandsToArchive = new ArrayList<DemandeUIModel>();
        List<DemandeUIModel> currentEmails = ((DemandeListUIModel)this.getModel()).getSelectedEmails();
        String notArchivableDemandTitles = "";
        for (DemandeUIModel demandeUIModel : currentEmails) {
            if (!demandeUIModel.isEditable() || !((DemandeListUIHandler)this.handler).isActionEnabled(demandeUIModel, MailAction.ARCHIVE, ((DemandeListUIHandler)this.handler).getConfiguration())) {
                notArchivableDemandTitles = notArchivableDemandTitles + "- " + demandeUIModel.getTitle() + "<br/>";
                continue;
            }
            this.demandsToArchive.add(demandeUIModel);
        }
        if (this.demandsToArchive.isEmpty()) {
            this.displayWarningMessage(I18n.t((String)"faxtomail.alert.noDemandToArchive.title", (Object[])new Object[0]), I18n.t((String)"faxtomail.alert.noDemandToArchive.message", (Object[])new Object[]{notArchivableDemandTitles}));
            result = false;
        } else {
            String message = !notArchivableDemandTitles.isEmpty() ? I18n.t((String)"faxtomail.alert.archivesWithNotArchivableConfirmation.message", (Object[])new Object[]{notArchivableDemandTitles}) : (this.demandsToArchive.size() == 1 ? I18n.t((String)"faxtomail.alert.archiveConfirmation.message", (Object[])new Object[0]) : I18n.t((String)"faxtomail.alert.archivesConfirmation.message", (Object[])new Object[0]));
            int i = JOptionPane.showConfirmDialog(null, message, I18n.t((String)"faxtomail.alert.archiveConfirmation.title", (Object[])new Object[0]), 0, 3);
            result = i == 0;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        MailFolder folder = this.demandsToArchive.get(0).getMailFolder();
        MailFolder archiveChild = null;
        do {
            Optional optArchiveChild;
            if (folder.getChildren() != null && (optArchiveChild = Iterables.tryFind((Iterable)folder.getChildren(), (Predicate)new Predicate<MailFolder>(){

                public boolean apply(MailFolder mailFolder) {
                    return mailFolder.isArchiveFolder();
                }
            })).isPresent()) {
                archiveChild = (MailFolder)optArchiveChild.get();
            }
            folder = folder.getParent();
        } while (archiveChild == null && folder != null);
        for (DemandeUIModel email : this.demandsToArchive) {
            email.setArchiveDate(new Date());
            email.setDemandStatus(DemandStatus.ARCHIVED);
            email.setTakenBy(null);
            if (archiveChild == null) continue;
            email.setMailFolder(archiveChild);
        }
        this.modifiedProperties = new String[]{"archiveDate"};
        super.doAction();
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        List<DemandeUIModel> selectedEmails = ((DemandeListUIModel)this.getModel()).getSelectedEmails();
        ((DemandeListUIModel)this.getModel()).removeEmails(selectedEmails);
        if (this.getContext().isUseFolderCache()) {
            this.getContext().getCurrentFolderEmails().removeAllDemands(selectedEmails);
        }
        ((DemandeListUIModel)this.getModel()).setSelectedEmails(null);
    }
}

