package com.franciaflex.faxtomail.ui.swing.content.demande;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static org.nuiton.i18n.I18n.t;

public class QuantitiesByRangeUI extends JPanel implements FaxToMailUI<QuantitiesByRangeUIModel, QuantitiesByRangeUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Uz08TQRR+rLS0BURpqBgwQSXReJgSrxjBYhqpxR9UEmIvTrtTGJjdGWZnZbkY/wT/BL17MfHmyXjw7MGL8V8wxoNX45ttaSldAwd7mMO8733vm7ff17c/IBVouLxDo4jo0DfcY6RyZ3PzYWOHNc1dFjQ1V0ZqaP+GHHDqMOp27wMDV+tV217stBdXpKekz/wj3YtVyAXmQLBgmzFj4FJ/RzMIirVueTFSoT5k7YpKYn3966fzyn35xgGIFKpL41PmTurqvWS4Cg53DUzipOe0KKi/hTI097dQ77i9WxE0CB5Qj+3BCxipQlpRjWQGrpz+yTFH3B8pA/m9kGKP4SwoHazjRLaxaqDclB5paeo3OW0JFpEWjYz0KBck5CTYR0mkKX2DE4jLPOq7jDweJFIqHpQ2kPKky4SB+/+HeM2y9djH5yu1ppZCPKI+WzBwwe4q6tAdKVl4ttuV05bsCW0IZmBG6i2ygz7aNVK1OyNS2YyrFj/RbcvMVyyXwDmTfXPi2/4RGblbCo3BB0G+D9u+tagphSaZ6TMJ2o/07Nfzx1AdUjrEawPT9UHHrmOp7dXpY161hHH1TyH/9cP39+VDg9qsTSVCj+QLjaO0VEzbT2Bgou3O0HBRXKNqsQ7ZgAkMZxy+2QRhtU4ZxeG887ad2HZyjwbbSJEa+fbxU+HZlzPglCEnJHXL1OJXIWu2NW5BCjdSS8uxorH9DJ7nrDbU4tGIe6G3LvdXZGiD4NxciHADswkb6MpoZD//ztfeLR9uwUFVF/8J720i9RTS3BfcZ3FQOxlMDOaoCljoyl7WktIHmL9CiVG/zIVh2loNg9uQJRl1vH3DQsYs5FhhLj7nk3aSYS43bVOnWlQELAot9rqtdkj7vK9Ophw2LMLdXuuFdeBfgzRiRxOLTBrYTcIpxqUFPZAIhrO3XGroXIP7Lqbm9gDvkD1zJzLa6yV7LCczFJDhLz6seLF5BgAA";
    private static final Log log = LogFactory.getLog(QuantitiesByRangeUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected final QuantitiesByRangeUIHandler handler = createHandler();
    protected QuantitiesByRangeUIModel model;
    protected JButton okButton;
    protected QuantitiesByRangeUI quantitiesByRangeUI = this;
    protected JXTable rangeTable;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public QuantitiesByRangeUI(FaxToMailUI parentUI) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public QuantitiesByRangeUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public QuantitiesByRangeUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public QuantitiesByRangeUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public QuantitiesByRangeUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public QuantitiesByRangeUI() {
        $initialize();
    }

    public QuantitiesByRangeUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public QuantitiesByRangeUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public QuantitiesByRangeUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__okButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public QuantitiesByRangeUIHandler getHandler() {
        return handler;
    }

    public QuantitiesByRangeUIModel getModel() {
        return model;
    }

    public JButton getOkButton() {
        return okButton;
    }

    public JXTable getRangeTable() {
        return rangeTable;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToQuantitiesByRangeUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JScrollPane0, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected QuantitiesByRangeUIHandler createHandler() {
        return new QuantitiesByRangeUIHandler();
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(QuantitiesByRangeUIModel.class));
    }

    protected void createOkButton() {
        $objectMap.put("okButton", okButton = new JButton());
        
        okButton.setName("okButton");
        okButton.setText(t("faxtomail.quantitiesByRange.button.text"));
        okButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__okButton"));
    }

    protected void createRangeTable() {
        $objectMap.put("rangeTable", rangeTable = new JXTable());
        
        rangeTable.setName("rangeTable");
        rangeTable.setEditable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToQuantitiesByRangeUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(rangeTable);
        // inline complete setup of $JPanel0
        $JPanel0.add(okButton);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("quantitiesByRangeUI", quantitiesByRangeUI);
        createModel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createRangeTable();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createOkButton();
        // inline creation of quantitiesByRangeUI
        setName("quantitiesByRangeUI");
        setLayout(new BorderLayout());
        
        $completeSetup();
        handler.afterInit(this);
    }

}