/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service;

import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.DemandTypeTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroupTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUserTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.persistence.entities.HistoryTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.HistoryType;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.MailFolderTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.OriginalEmailTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.PriorityTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.persistence.entities.RangeRow;
import com.franciaflex.faxtomail.persistence.entities.RangeRowTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.RangeTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.persistence.entities.WaitingStateTopiaDao;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.franciaflex.faxtomail.services.FaxToMailServiceUtils;
import com.franciaflex.faxtomail.services.service.InitFaxToMailService;
import com.franciaflex.faxtomail.services.service.exceptions.InvalidClientException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class InitFaxToMailServiceImpl
extends FaxToMailServiceSupport
implements InitFaxToMailService {
    private static final Log log = LogFactory.getLog(InitFaxToMailServiceImpl.class);

    @Override
    public void init() {
        boolean devMode;
        if (log.isInfoEnabled()) {
            log.info((Object)"faxtomail initialization started");
        }
        if (devMode = this.serviceContext.getApplicationConfig().isDevMode()) {
            this.initSampleData();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"faxtomail initialization done");
        }
    }

    protected void initSampleData() {
        log.debug((Object)"init Sample Data");
        DemandTypeTopiaDao demandTypeDao = this.getPersistenceContext().getDemandTypeDao();
        long count = demandTypeDao.count();
        if (count == 0L) {
            ArrayList types = Lists.newArrayList((Object[])new DemandType[]{(DemandType)demandTypeDao.create("label", (Object)"Commande", new Object[]{"requiredFields", EnumSet.of(MailField.RANGE_ROW)}), (DemandType)demandTypeDao.create("label", (Object)"Commande R\u00e9ponse", new Object[0]), (DemandType)demandTypeDao.create("label", (Object)"Commande Annulation/Modification", new Object[0]), (DemandType)demandTypeDao.create("label", (Object)"Devis Diffus", new Object[0]), (DemandType)demandTypeDao.create("label", (Object)"Devis Chantier", new Object[0]), (DemandType)demandTypeDao.create("label", (Object)"Devis Gros Chantier", new Object[0]), (DemandType)demandTypeDao.create("label", (Object)"Devis R\u00e9ponse/Modification", new Object[0]), (DemandType)demandTypeDao.create("label", (Object)"R\u00e9clamation", new Object[0]), (DemandType)demandTypeDao.create("label", (Object)"Autres", new Object[0])});
            WaitingStateTopiaDao waitingStateDao = this.getPersistenceContext().getWaitingStateDao();
            ArrayList waitingStates = Lists.newArrayList((Object[])new WaitingState[]{(WaitingState)waitingStateDao.create("label", (Object)"BAT attente retour BAT lettrage-logo", new Object[0]), (WaitingState)waitingStateDao.create("label", (Object)"CLT attente r\u00e9ponse client", new Object[0]), (WaitingState)waitingStateDao.create("label", (Object)"DAC attente pour assistance chantier", new Object[0]), (WaitingState)waitingStateDao.create("label", (Object)"DAV attente analyse avoir", new Object[0]), (WaitingState)waitingStateDao.create("label", (Object)"EXP attente expertise", new Object[0]), (WaitingState)waitingStateDao.create("label", (Object)"GAB attente reception gabarit", new Object[0]), (WaitingState)waitingStateDao.create("label", (Object)"GRA attente accord gratuit", new Object[0]), (WaitingState)waitingStateDao.create("label", (Object)"ODC attente Ouverture de Compte", new Object[0]), (WaitingState)waitingStateDao.create("label", (Object)"PPC attente chiffrage BEI PPC", new Object[0]), (WaitingState)waitingStateDao.create("label", (Object)"PROFORMA attente paiement proforma", new Object[0]), (WaitingState)waitingStateDao.create("label", (Object)"PROTO attente accord proto", new Object[0]), (WaitingState)waitingStateDao.create("label", (Object)"REM Attente Remise-accord expo", new Object[0]), (WaitingState)waitingStateDao.create("label", (Object)"RET attente retour materiel", new Object[0]), (WaitingState)waitingStateDao.create("label", (Object)"SIGN attente r\u00e9ponse BEI signature", new Object[0]), (WaitingState)waitingStateDao.create("label", (Object)"SPAM", new Object[0])});
            PriorityTopiaDao priorityDao = this.getPersistenceContext().getPriorityDao();
            ArrayList priorities = Lists.newArrayList((Object[])new Priority[]{(Priority)priorityDao.create("label", (Object)"!", new Object[0]), (Priority)priorityDao.create("label", (Object)"F", new Object[0])});
            RangeTopiaDao rangeDao = this.getPersistenceContext().getRangeDao();
            ArrayList ranges = Lists.newArrayList((Object[])new Range[]{(Range)rangeDao.create("label", (Object)"FFE VR", new Object[0]), (Range)rangeDao.create("label", (Object)"FFE AUTRE", new Object[0]), (Range)rangeDao.create("label", (Object)"FME FX DROIT", new Object[0]), (Range)rangeDao.create("label", (Object)"FME FX CINTRE", new Object[0]), (Range)rangeDao.create("label", (Object)"FME NOEL", new Object[0]), (Range)rangeDao.create("label", (Object)"FSE BANNE", new Object[0]), (Range)rangeDao.create("label", (Object)"FSE ROCH AUTRE", new Object[0]), (Range)rangeDao.create("label", (Object)"FSE CHECY", new Object[0]), (Range)rangeDao.create("label", (Object)"FSI", new Object[0]), (Range)rangeDao.create("label", (Object)"FSI FMI", new Object[0])});
            FaxToMailUserGroupTopiaDao userGroupDao = this.getPersistenceContext().getFaxToMailUserGroupDao();
            userGroupDao.create("name", (Object)"Charg\u00e9s de client\u00e8le", new Object[]{"completeName", "Franciaflex/Charg\u00e9s de client\u00e8le"});
            FaxToMailUserGroup commerciauxGroup = (FaxToMailUserGroup)userGroupDao.create("name", (Object)"Commerciaux", new Object[]{"completeName", "Franciaflex/Commerciaux"});
            FaxToMailUserGroup savGroup = (FaxToMailUserGroup)userGroupDao.create("name", (Object)"SAV", new Object[]{"completeName", "Franciaflex/SAV"});
            userGroupDao.create("name", (Object)"Administrateurs", new Object[]{"completeName", "Franciaflex/Administrateurs"});
            FaxToMailUserTopiaDao userDao = this.getPersistenceContext().getFaxToMailUserDao();
            FaxToMailUser marc = (FaxToMailUser)userDao.create("lastName", (Object)"Lef\u00e8bvre", new Object[]{"firstName", "Marc", "login", "mlefebvre", "trigraph", "MLE", "userGroups", Collections.singletonList(commerciauxGroup)});
            FaxToMailUser cyril = (FaxToMailUser)userDao.create("lastName", (Object)"Baillet", new Object[]{"firstName", "Cyril", "login", "cbaillet", "trigraph", "CBA"});
            FaxToMailUser frederic = (FaxToMailUser)userDao.create("lastName", (Object)"Viala", new Object[]{"firstName", "Fr\u00e9d\u00e9ric", "login", "fviala", "trigraph", "FVI", "userGroups", Collections.singletonList(commerciauxGroup)});
            FaxToMailUser claire = (FaxToMailUser)userDao.create("lastName", (Object)"Marquis", new Object[]{"firstName", "Claire", "login", "cmarquis", "trigraph", "CMA"});
            FaxToMailUser agathe = (FaxToMailUser)userDao.create("lastName", (Object)"Borde", new Object[]{"firstName", "Agathe", "login", "aborde", "trigraph", "ABO", "userGroups", Collections.singletonList(savGroup)});
            FaxToMailUser jeanne = (FaxToMailUser)userDao.create("lastName", (Object)"Bourgoin", new Object[]{"firstName", "Jeanne", "login", "jbourgoin", "trigraph", "JBO", "userGroups", Collections.singletonList(commerciauxGroup)});
            MailFolderTopiaDao folderDao = this.getPersistenceContext().getMailFolderDao();
            HashMap<String, MailFolder> folders = new HashMap<String, MailFolder>();
            Random random = new Random(1234L);
            EmailTopiaDao emailDao = this.getPersistenceContext().getEmailDao();
            OriginalEmailTopiaDao originalEmailDao = this.getPersistenceContext().getOriginalEmailDao();
            HistoryTopiaDao historyDao = this.getPersistenceContext().getHistoryDao();
            RangeRowTopiaDao rangeRowDao = this.getPersistenceContext().getRangeRowDao();
            int waitingStateSize = waitingStates.size();
            MailFolder franciaflex = (MailFolder)folderDao.create("name", (Object)"Franciaflex", new Object[]{"useCurrentLevelCompany", true, "company", "FX", "useCurrentLevelRejectResponseMailAddress", true, "useCurrentLevelRejectResponseMessage", true});
            MailFolder faber = (MailFolder)folderDao.create("name", (Object)"Faber", new Object[0]);
            MailFolder franceFermeture = (MailFolder)folderDao.create("name", (Object)"France Fermetures", new Object[]{"useCurrentLevelCompany", true, "company", "FF"});
            MailFolder chargesClientelle = (MailFolder)folderDao.create("name", (Object)"Charg\u00e9s de client\u00e8le", new Object[]{"parent", franciaflex, "replyAddresses", Lists.newArrayList((Object[])new String[]{"no-reply@franciaflex.com"})});
            franciaflex.addChildren(chargesClientelle);
            folders.put("Charg\u00e9s de client\u00e8le", chargesClientelle);
            Collections.shuffle(waitingStates);
            MailFolder sav = (MailFolder)folderDao.create("name", (Object)"SAV", new Object[]{"parent", franciaflex, "waitingStates", waitingStates.subList(0, random.nextInt(waitingStateSize - 8) + 2), "useCurrentLevelWaitingState", true});
            franciaflex.addChildren(sav);
            folders.put("SAV", sav);
            Collections.shuffle(waitingStates);
            MailFolder cyrilFolder = (MailFolder)folderDao.create("name", (Object)"Cyril", new Object[]{"parent", chargesClientelle, "waitingStates", waitingStates.subList(0, random.nextInt(waitingStateSize - 8) + 2), "useCurrentLevelWaitingState", true});
            chargesClientelle.addChildren(cyrilFolder);
            folders.put("Cyril", cyrilFolder);
            MailFolder claireFolder = (MailFolder)folderDao.create("name", (Object)"Claire", new Object[]{"parent", chargesClientelle});
            chargesClientelle.addChildren(claireFolder);
            folders.put("Claire", claireFolder);
            Collections.shuffle(waitingStates);
            MailFolder agatheFolder = (MailFolder)folderDao.create("name", (Object)"Agathe", new Object[]{"parent", chargesClientelle, "waitingStates", waitingStates.subList(0, random.nextInt(waitingStateSize - 8) + 2), "useCurrentLevelWaitingState", true});
            chargesClientelle.addChildren(agatheFolder);
            folders.put("Agathe", agatheFolder);
            MailFolder marcFolder = (MailFolder)folderDao.create("name", (Object)"Marc", new Object[]{"parent", sav});
            sav.addChildren(marcFolder);
            folders.put("Marc", marcFolder);
            MailFolder fredericFolder = (MailFolder)folderDao.create("name", (Object)"Fr\u00e9d\u00e9ric", new Object[]{"parent", sav});
            sav.addChildren(fredericFolder);
            folders.put("Fr\u00e9d\u00e9ric", fredericFolder);
            MailFolder jeanneFolder = (MailFolder)folderDao.create("name", (Object)"Jeanne", new Object[]{"parent", sav});
            sav.addChildren(jeanneFolder);
            folders.put("Jeanne", jeanneFolder);
            File demoDirectory = this.getApplicationConfig().getDemoDirectory();
            File emailAcountFile = new File(demoDirectory, "email_accounts.csv");
            try {
                FileInputStream emailAccountsPropertiesStream = new FileInputStream(emailAcountFile);
                if (emailAccountsPropertiesStream != null) {
                    this.getReferentielService().importEmailAccounts(emailAccountsPropertiesStream);
                }
            }
            catch (Exception e) {
                log.error((Object)"error getting the email accounts", (Throwable)e);
            }
            File emailFilterFile = new File(demoDirectory, "email_filters.csv");
            try {
                FileInputStream emailFiltersPropertiesStream = new FileInputStream(emailFilterFile);
                if (emailFiltersPropertiesStream != null) {
                    this.getReferentielService().importEmailFilters(emailFiltersPropertiesStream, folders);
                }
            }
            catch (Exception e) {
                log.error((Object)"error getting the email filters", (Throwable)e);
            }
            File clientFile = new File(demoDirectory, "fx_clients.csv");
            try {
                FileInputStream fxClientsStream = new FileInputStream(clientFile);
                if (fxClientsStream != null) {
                    List<Client> clients = this.getReferentielService().importClients(fxClientsStream);
                    this.createEmails(random, historyDao, rangeRowDao, emailDao, originalEmailDao, ranges, clients, types, priorities, cyrilFolder, cyril);
                    this.createEmails(random, historyDao, rangeRowDao, emailDao, originalEmailDao, ranges, clients, types, priorities, claireFolder, claire);
                    this.createEmails(random, historyDao, rangeRowDao, emailDao, originalEmailDao, ranges, clients, types, priorities, agatheFolder, agathe);
                    this.createEmails(random, historyDao, rangeRowDao, emailDao, originalEmailDao, ranges, clients, types, priorities, marcFolder, marc);
                    this.createEmails(random, historyDao, rangeRowDao, emailDao, originalEmailDao, ranges, clients, types, priorities, fredericFolder, frederic);
                    this.createEmails(random, historyDao, rangeRowDao, emailDao, originalEmailDao, ranges, clients, types, priorities, jeanneFolder, jeanne);
                }
            }
            catch (Exception e) {
                log.error((Object)"error getting the client file", (Throwable)e);
            }
            this.getPersistenceContext().commit();
        }
    }

    protected void createEmails(Random random, HistoryTopiaDao historyDao, RangeRowTopiaDao rangeRowDao, EmailTopiaDao emailDao, OriginalEmailTopiaDao originalEmailDao, List<Range> ranges, List<Client> clients, List<DemandType> types, List<Priority> priorities, MailFolder folder, FaxToMailUser user) throws InvalidClientException {
        int r = random.nextInt(100) + 50;
        for (int i = 0; i < r; ++i) {
            this.createEmail(random, historyDao, rangeRowDao, emailDao, originalEmailDao, ranges, clients, types, priorities, folder, user);
        }
    }

    protected void createEmail(Random random, HistoryTopiaDao historyDao, RangeRowTopiaDao rangeRowDao, EmailTopiaDao emailDao, OriginalEmailTopiaDao originalEmailDao, List<Range> ranges, List<Client> clients, List<DemandType> types, List<Priority> priorities, MailFolder folder, FaxToMailUser user) throws InvalidClientException {
        ArrayList<RangeRow> rangeRows = new ArrayList<RangeRow>();
        Client client = clients.get(random.nextInt(clients.size()));
        boolean fax = false;
        List senders = client.getEmailAddresses();
        List faxNumbers = client.getFaxNumbers();
        if (CollectionUtils.isEmpty((Collection)senders) && CollectionUtils.isNotEmpty((Collection)faxNumbers)) {
            senders = Collections.singletonList(client.getFaxNumbers().get(0));
            fax = true;
        }
        String sender = null;
        if (CollectionUtils.isNotEmpty((Collection)senders)) {
            sender = (String)senders.get(0);
        }
        String faxNumber = null;
        if (CollectionUtils.isNotEmpty((Collection)faxNumbers)) {
            faxNumber = (String)faxNumbers.get(0);
        }
        boolean opened = random.nextBoolean();
        Decorator<Date> dateDecorator = this.getDecoratorService().getDecoratorByType(Date.class, "date");
        Date now = new Date();
        History history = (History)historyDao.create("type", (Object)HistoryType.CREATION, new Object[]{"modificationDate", now});
        history.setFields((Set)Sets.newHashSet((Object[])new String[]{"sender", "client", "projectReference", "object", "receptionDate", "mailFolder", "demandStatus"}));
        String projectRef = I18n.t((String)"faxtomail.email.projectReference.default", (Object[])new Object[]{dateDecorator.toString((Object)now)});
        Email email = (Email)emailDao.create("sender", (Object)sender, new Object[]{"fax", fax, "client", client, "projectReference", projectRef, "object", client.getCaracteristic1() + " / " + client.getCode() + " / " + client.getName() + " / " + faxNumber + " / " + dateDecorator.toString((Object)now), "receptionDate", now, "mailFolder", folder, "demandStatus", opened ? DemandStatus.IN_PROGRESS : DemandStatus.UNTREATED, "history", Lists.newArrayList((Object[])new History[]{history}), "originalEmail", originalEmailDao.create("content", (Object)"Demo data", new Object[0])});
        if (opened) {
            this.getEmailService().addToHistory(email.getTopiaId(), HistoryType.OPENING, user, now, new String[0]);
            DemandType demandType = types.get(random.nextInt(types.size()));
            if (FaxToMailServiceUtils.contains(demandType.getRequiredFields(), MailField.RANGE_ROW)) {
                for (int j = 0; j < random.nextInt(4) + 1; ++j) {
                    RangeRow rangeRow = (RangeRow)rangeRowDao.create("range", (Object)ranges.get(random.nextInt(ranges.size())), new Object[]{"commandNumber", RandomStringUtils.randomNumeric((int)6), "productQuantity", random.nextInt(100), "savQuantity", random.nextInt(100)});
                    rangeRows.add(rangeRow);
                }
                email.setRangeRow(rangeRows);
            }
            email.setDemandType(demandType);
            email.setPriority(priorities.get(random.nextInt(priorities.size())));
            email.setRangeRow(rangeRows);
            this.getEmailService().saveEmail(email, user, "demandType", "priority", "rangeRow");
        }
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        Date yesterday = cal.getTime();
        history = (History)historyDao.create("type", (Object)HistoryType.CREATION, new Object[]{"modificationDate", yesterday});
        history.setFields((Set)Sets.newHashSet((Object[])new String[]{"sender", "client", "projectReference", "object", "receptionDate", "mailFolder", "demandStatus"}));
        projectRef = I18n.t((String)"faxtomail.email.projectReference.default", (Object[])new Object[]{dateDecorator.toString((Object)yesterday)});
        email = (Email)emailDao.create("sender", (Object)sender, new Object[]{"fax", fax, "client", client, "projectReference", projectRef, "object", client.getCaracteristic1() + " / " + client.getCode() + " / " + client.getName() + " / " + faxNumber + " / " + dateDecorator.toString((Object)yesterday), "receptionDate", yesterday, "mailFolder", folder, "demandStatus", opened ? DemandStatus.IN_PROGRESS : DemandStatus.UNTREATED, "history", Lists.newArrayList((Object[])new History[]{history}), "originalEmail", originalEmailDao.create("content", (Object)"Demo data", new Object[0])});
        if (opened) {
            this.getEmailService().addToHistory(email.getTopiaId(), HistoryType.OPENING, user, now, new String[0]);
            DemandType demandType = types.get(random.nextInt(types.size()));
            if (FaxToMailServiceUtils.contains(demandType.getRequiredFields(), MailField.RANGE_ROW)) {
                for (int j = 0; j < random.nextInt(4) + 1; ++j) {
                    RangeRow rangeRow = (RangeRow)rangeRowDao.create("range", (Object)ranges.get(random.nextInt(ranges.size())), new Object[]{"commandNumber", RandomStringUtils.randomNumeric((int)6), "productQuantity", random.nextInt(100), "savQuantity", random.nextInt(100)});
                    rangeRows.add(rangeRow);
                }
                email.setRangeRow(rangeRows);
                if (random.nextBoolean()) {
                    email.setEdiError("error 42");
                }
            }
            email.setDemandType(demandType);
            email.setPriority(priorities.get(random.nextInt(priorities.size())));
            email.setRangeRow(rangeRows);
            this.getEmailService().saveEmail(email, null, null, user, "demandType", "priority", "rangeRow");
        }
    }
}

