package com.franciaflex.faxtomail.services.service;

/*
 * #%L
 * FaxToMail :: Service
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Client;
import com.franciaflex.faxtomail.persistence.entities.ClientTopiaDao;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.services.FaxToMailServiceSupport;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class ClientService extends FaxToMailServiceSupport {

    private static final Log log = LogFactory.getLog(ClientService.class);

    public Client getClientForEmailAddress(String emailAddress, Email email) {
        Preconditions.checkNotNull(email);
        Preconditions.checkNotNull(emailAddress);

        ClientTopiaDao clientDao = getPersistenceContext().getClientDao();

        Client client = null;
        List<Client> clients;
        if (StringUtils.isNotBlank(emailAddress)) {
            clients = clientDao.forEmailAddressEquals(emailAddress).findAll();

            if (CollectionUtils.isEmpty(clients)) {
                emailAddress = emailAddress.substring(0, emailAddress.indexOf('@'));
                if (NumberUtils.isNumber(emailAddress)) {
                    emailAddress = StringUtils.leftPad(emailAddress, 10, '0');
                    clients = clientDao.forFaxNumberEquals(emailAddress).findAll();
                    email.setFax(true);
                }
            }

            if (CollectionUtils.isNotEmpty(clients)) {
                MailFolder folder = email.getMailFolder();
                if (clients.size() == 1) {
                    client = clients.get(0);

                } else if (folder != null) {
                    Multimap<String, Client> clientsByBrand = Multimaps.index(clients, new Function<Client, String>() {
                        @Override
                        public String apply(Client client) {
                            return client.getBrand();
                        }
                    });
                    Set<String> brands = clientsByBrand.keySet();
                    while (client == null && folder != null) {
                        if (brands.contains(folder.getName())) {
                            client = new ArrayList<>(clientsByBrand.get(folder.getName())).get(0);
                        }
                        folder = folder.getParent();
                    }
                }
            }
        }
        return client;
    }

    public Client getClientForCode(String code) {
        ClientTopiaDao clientDao = getPersistenceContext().getClientDao();
        Client client = null;
        if (StringUtils.isNotBlank(code)) {
            client = clientDao.forCodeEquals(code).findAnyOrNull();
        }
        return client;
    }
}
