/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.failover;

import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationNode;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.lite.internal.config.LiteJobConfigurationGsonFactory;
import com.dangdang.ddframe.job.lite.internal.failover.FailoverService;
import com.dangdang.ddframe.job.lite.internal.instance.InstanceNode;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingService;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.util.List;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public final class FailoverListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final ConfigurationService configService;
    private final ShardingService shardingService;
    private final FailoverService failoverService;
    private final ConfigurationNode configNode;
    private final InstanceNode instanceNode;

    public FailoverListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.jobName = jobName;
        this.configService = new ConfigurationService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.failoverService = new FailoverService(regCenter, jobName);
        this.configNode = new ConfigurationNode(jobName);
        this.instanceNode = new InstanceNode(jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new JobCrashedJobListener());
        this.addDataListener(new FailoverSettingsChangedJobListener());
    }

    private boolean isFailoverEnabled() {
        LiteJobConfiguration jobConfig = this.configService.load(true);
        return null != jobConfig && jobConfig.isFailover();
    }

    class FailoverSettingsChangedJobListener
    extends AbstractJobListener {
        FailoverSettingsChangedJobListener() {
        }

        @Override
        protected void dataChanged(String path, TreeCacheEvent.Type eventType, String data) {
            if (FailoverListenerManager.this.configNode.isConfigPath(path) && TreeCacheEvent.Type.NODE_UPDATED == eventType && !LiteJobConfigurationGsonFactory.fromJson(data).isFailover()) {
                FailoverListenerManager.this.failoverService.removeFailoverInfo();
            }
        }
    }

    class JobCrashedJobListener
    extends AbstractJobListener {
        JobCrashedJobListener() {
        }

        @Override
        protected void dataChanged(String path, TreeCacheEvent.Type eventType, String data) {
            block5: {
                if (!FailoverListenerManager.this.isFailoverEnabled() || TreeCacheEvent.Type.NODE_REMOVED != eventType || !FailoverListenerManager.this.instanceNode.isInstancePath(path)) break block5;
                String jobInstanceId = path.substring(FailoverListenerManager.this.instanceNode.getInstanceFullPath().length() + 1);
                if (jobInstanceId.equals(JobRegistry.getInstance().getJobInstance(FailoverListenerManager.this.jobName).getJobInstanceId())) {
                    return;
                }
                List<Integer> failoverItems = FailoverListenerManager.this.failoverService.getFailoverItems(jobInstanceId);
                if (!failoverItems.isEmpty()) {
                    for (int each : failoverItems) {
                        FailoverListenerManager.this.failoverService.setCrashedFailoverFlag(each);
                        FailoverListenerManager.this.failoverService.failoverIfNecessary();
                    }
                } else {
                    for (int each : FailoverListenerManager.this.shardingService.getShardingItems(jobInstanceId)) {
                        FailoverListenerManager.this.failoverService.setCrashedFailoverFlag(each);
                        FailoverListenerManager.this.failoverService.failoverIfNecessary();
                    }
                }
            }
        }
    }
}

